/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.concurrent.NamedThreadFactory;
import com.xunlei.netty.util.spring.AfterConfig;
import com.xunlei.netty.util.spring.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.util.internal.ExecutorUtil;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public final class NettyServerConfig {
    public static final Logger ALARMLOG = Log.getLogger("alarm.com.xunlei.netty");
    public static final int CORE_PROCESSOR_NUM = Runtime.getRuntime().availableProcessors();
    private static XLHttpResponse.ContentType respInnerContentType = XLHttpResponse.ContentType.json;
    @Config
    private int listen_port = 80;
    @Config
    private int listen_soa_port = 0;
    @Config
    private int listen_grpc_port = 0;
    @Config
    private boolean consulIsEnable = false;
    @Config
    private String consulServiceName = "";
    @Config(resetable=true)
    private String serverSignKey = "";
    @Config
    private int connectTimeoutMillis = 5000;
    @Config
    private int receiveBufferSize = 8192;
    @Config
    private int sendBufferSize = 8192;
    @Config
    private String cmdSuffix = "Cmd";
    @Config
    private String cmdDefaultMethod = "process";
    @Config
    public int workerCount = 0;
    @Config
    private long plMaxChannelMemorySize = 0x6400000L;
    @Config
    private long plMaxTotalMemorySize = 0x40000000L;
    @Config(resetable=true)
    private int plCorePoolSize = CORE_PROCESSOR_NUM * 50;
    @Config
    private long plKeepAliveSecond = 60L;
    @Config(resetable=true)
    private String plAddBefore = "pageDispatcher";
    @Config
    private boolean plAddDefalter = false;
    @Config
    private static long plAddDefalterContentLen = 1024L;
    @Config
    private String respDefaultContentType = "json";
    @Config(resetable=true)
    private static int keepAliveTimeout = 2;
    @Config(resetable=true)
    private boolean debugEnable = true;
    @Config(resetable=true)
    private static String ipWhiteList = "";
    @Config
    private String jredisPropertiesUrl = "";
    private List<ComboPooledDataSource> c3p0ComboPool = new ArrayList<ComboPooledDataSource>();
    public static final ExecutorService bossExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O server boss $", 10));
    public static final ExecutorService workerExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O server worker $", 9));
    private MemoryAwareThreadPoolExecutor pipelineExecutorOrdered;

    public static long getPlAddDefalterContentLen() {
        return plAddDefalterContentLen;
    }

    @AfterConfig
    public void initPipelineExecutorOrdered() {
        if (this.pipelineExecutorOrdered == null) {
            this.pipelineExecutorOrdered = new OrderedMemoryAwareThreadPoolExecutor(this.plCorePoolSize, this.plMaxChannelMemorySize, this.plMaxTotalMemorySize, this.plKeepAliveSecond, TimeUnit.SECONDS, (ThreadFactory)new NamedThreadFactory("PIPELINE_ORD#", 7));
        } else {
            this.pipelineExecutorOrdered.setCorePoolSize(this.plCorePoolSize);
            this.pipelineExecutorOrdered.setMaximumPoolSize(this.plCorePoolSize);
            this.pipelineExecutorOrdered.setKeepAliveTime(this.plKeepAliveSecond, TimeUnit.SECONDS);
        }
    }

    @AfterConfig
    public void initRespInnerContentType() {
        respInnerContentType = "xml".equalsIgnoreCase(this.respDefaultContentType) ? XLHttpResponse.ContentType.xml : ("html".equalsIgnoreCase(this.respDefaultContentType) ? XLHttpResponse.ContentType.html : ("plain".equalsIgnoreCase(this.respDefaultContentType) ? XLHttpResponse.ContentType.plain : XLHttpResponse.ContentType.json));
    }

    public OrderedMemoryAwareThreadPoolExecutor getPipelineExecutor() {
        return (OrderedMemoryAwareThreadPoolExecutor)this.getPipelineExecutorOrdered();
    }

    public MemoryAwareThreadPoolExecutor getPipelineExecutorOrdered() {
        if (null == this.pipelineExecutorOrdered) {
            this.initPipelineExecutorOrdered();
        }
        return this.pipelineExecutorOrdered;
    }

    public void setPlCorePoolSize(int plCorePoolSize) {
        this.plCorePoolSize = plCorePoolSize;
        this.initPipelineExecutorOrdered();
    }

    public void setPlKeepAliveSecond(long plKeepAliveSecond) {
        this.plKeepAliveSecond = plKeepAliveSecond;
        this.initPipelineExecutorOrdered();
    }

    public int getRealWorkerCount() {
        if (this.workerCount < 0) {
            return CORE_PROCESSOR_NUM * this.workerCount * -1;
        }
        if (this.workerCount == 0) {
            return CORE_PROCESSOR_NUM * 2;
        }
        return this.workerCount;
    }

    public int getListen_port() {
        return this.listen_port;
    }

    public int getListen_soa_port() {
        return this.listen_soa_port;
    }

    public int getListen_grpc_port() {
        return this.listen_grpc_port;
    }

    public boolean isConsulIsEnable() {
        return this.consulIsEnable;
    }

    public String getConsulServiceName() {
        return this.consulServiceName;
    }

    public String getServerSignKey() {
        return this.serverSignKey;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public static int getKeepAliveTimeout() {
        return keepAliveTimeout;
    }

    public boolean isDebugEnable() {
        return this.debugEnable;
    }

    public String getCmdSuffix() {
        return this.cmdSuffix;
    }

    public String getCmdDefaultMethod() {
        return this.cmdDefaultMethod;
    }

    public String getPlAddBefore() {
        return this.plAddBefore;
    }

    public boolean isPlAddDefalter() {
        return this.plAddDefalter;
    }

    public static XLHttpResponse.ContentType getRespInnerContentType() {
        return respInnerContentType;
    }

    public void setRespDefaultContentType(String respDefaultContentType) {
        this.respDefaultContentType = respDefaultContentType;
        this.initRespInnerContentType();
    }

    public String getIpWhiteList() {
        return ipWhiteList;
    }

    public static void releaseExternalResources() {
        ExecutorUtil.terminate((Executor[])new Executor[]{bossExecutor, workerExecutor});
    }

    public String getJredisPropertiesUrl() {
        return this.jredisPropertiesUrl;
    }

    public List<ComboPooledDataSource> getC3p0ComboPool() {
        return this.c3p0ComboPool;
    }
}

