/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util;

import com.xunlei.netty.exception.BaseRuntimeException;
import io.grpc.CallOptions;
import io.grpc.Metadata;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GRPCServerHelper {
    public static final Metadata.Key<String> MDKey_ClientIP = Metadata.Key.of((String)"MDKey_ClientIP", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> MDKey_ClientAppName = Metadata.Key.of((String)"MDKey_ClientAppName", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> MDKey_ChildId = Metadata.Key.of((String)"MDKey_ChildId", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> MDKey_RootMessageId = Metadata.Key.of((String)"MDKey_RootMessageId", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> MDKey_MessageId = Metadata.Key.of((String)"MDKey_MessageId", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> MDKey_ServiceIPKey = Metadata.Key.of((String)"MDKey_ServiceIPKey", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> MDKey_ServicePortKey = Metadata.Key.of((String)"MDKey_ServicePortKey", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> MDKey_ErrorCode = Metadata.Key.of((String)"MDKey_ErrorCode", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<byte[]> MDKey_ErrorMsg = Metadata.Key.of((String)"MDKey_ErrorMsg-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
    public static final CallOptions.Key<Boolean> COKey_IsAsyncInterface = CallOptions.Key.of((String)"COKey_IsAsyncInterface", (Object)false);
    public static final CallOptions.Key<Long> COKey_ConnectionTimeout = CallOptions.Key.of((String)"COKey_ConnectionTimeout", (Object)0L);

    public static Metadata getMetadataFromException(Exception e) {
        Metadata metadata = new Metadata();
        if (e != null) {
            String code = "";
            String msg = "";
            if (e instanceof BaseRuntimeException) {
                code = ((BaseRuntimeException)e).getErrorCode();
                msg = ((BaseRuntimeException)e).getMessage();
            } else if (StringUtils.isNotBlank((String)e.getMessage())) {
                msg = e.getMessage();
            }
            metadata.put(MDKey_ErrorCode, (Object)code);
            metadata.put(MDKey_ErrorMsg, (Object)msg.getBytes());
        }
        return metadata;
    }

    public static String getExceptionStringFromMetadata(Metadata metadata) {
        String exStr = "";
        if (metadata != null) {
            if (metadata.containsKey(MDKey_ErrorCode)) {
                exStr = exStr + "ErrorCode:" + (String)metadata.get(MDKey_ErrorCode) + ";";
            }
            if (metadata.containsKey(MDKey_ErrorMsg)) {
                exStr = exStr + "ErrorMsg:" + new String((byte[])metadata.get(MDKey_ErrorMsg)) + ";";
            }
        }
        return exStr;
    }

    public static String getExceptionStringFromException(Exception e) {
        String exStr = "";
        if (e != null) {
            exStr = e.getMessage();
            if (e instanceof StatusException) {
                exStr = exStr + ";" + GRPCServerHelper.getExceptionStringFromMetadata(((StatusException)e).getTrailers());
            } else if (e instanceof StatusRuntimeException) {
                exStr = exStr + ";" + GRPCServerHelper.getExceptionStringFromMetadata(((StatusRuntimeException)e).getTrailers());
            }
        }
        return exStr;
    }

    public static String getExceptionCodeFromException(Exception e) {
        String exCode = "";
        if (e != null) {
            Metadata metadata = null;
            if (e instanceof StatusException) {
                metadata = ((StatusException)e).getTrailers();
            } else if (e instanceof StatusRuntimeException) {
                metadata = ((StatusRuntimeException)e).getTrailers();
            }
            if (metadata != null) {
                exCode = (String)metadata.get(MDKey_ErrorCode);
            }
        }
        return exCode;
    }

    public static String getExceptionMsgFromException(Exception e) {
        String exMsg = "";
        if (e != null) {
            Metadata metadata = null;
            if (e instanceof StatusException) {
                metadata = ((StatusException)e).getTrailers();
            } else if (e instanceof StatusRuntimeException) {
                metadata = ((StatusRuntimeException)e).getTrailers();
            }
            exMsg = metadata != null && metadata.containsKey(MDKey_ErrorMsg) ? new String((byte[])metadata.get(MDKey_ErrorMsg)) : e.getMessage();
        }
        return exMsg;
    }

    public static boolean equalsList(List<?> list1, List<?> list2) {
        if (!(list1 != null && list1.size() != 0 || list2 != null && list2.size() != 0)) {
            return true;
        }
        return list1 != null && list2 != null && list1.size() == list2.size() && list1.containsAll(list2) && list2.containsAll(list1);
    }
}

