/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.soaserver.component;

import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAAdmin;
import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAMethodAlias;
import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAMethodAsyn;
import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAMethodRetry;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public class RpcObjectBase {
    private String interfaceName;
    private String methodName;
    private String name;
    private String simpleName;
    private String token;
    private String isAsynMethod = Boolean.toString(false);
    private boolean isAdmin = false;
    private int retryCount = 0;

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getIsAsynMethod() {
        return this.isAsynMethod;
    }

    public void setIsAsynMethod(String isAsynMethod) {
        this.isAsynMethod = isAsynMethod;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setRpcObject(Class<?> interfaceClass, Method method) {
        if (interfaceClass != null) {
            this.interfaceName = interfaceClass.getName();
        }
        if (method != null) {
            CmdSOAMethodRetry methodRetry;
            this.methodName = method.getName();
            if (method.getAnnotation(CmdSOAMethodAlias.class) != null) {
                CmdSOAMethodAlias aliasMethod = method.getAnnotation(CmdSOAMethodAlias.class);
                this.name = this.interfaceName + "." + aliasMethod.value();
                this.simpleName = this.interfaceName + "." + this.methodName + "(Alias:" + aliasMethod.value() + ")";
            } else {
                this.simpleName = this.name = this.interfaceName + "." + this.methodName;
            }
            this.token = UUID.randomUUID().toString();
            if (method.getAnnotation(CmdSOAMethodAsyn.class) != null) {
                this.isAsynMethod = Boolean.toString(true);
            }
            if (method.getAnnotation(CmdSOAAdmin.class) != null) {
                this.isAdmin = true;
            }
            if ((methodRetry = method.getAnnotation(CmdSOAMethodRetry.class)) != null) {
                this.retryCount = methodRetry.retryCount();
            }
            String argStr = "";
            if (method.getParameterTypes() != null && method.getParameterTypes().length > 0) {
                ArrayList<String> typeNameList = new ArrayList<String>(method.getParameterTypes().length);
                for (Class<?> parType : method.getParameterTypes()) {
                    typeNameList.add(parType.getSimpleName());
                }
                argStr = StringUtils.join((Object[])typeNameList.toArray(), (String)", ");
            }
        }
    }
}

