/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.soaserver.component;

import com.xunlei.netty.exception.BaseRuntimeException;
import com.xunlei.netty.soaserver.component.DTOBase;
import java.lang.reflect.Constructor;
import org.apache.commons.lang.StringUtils;

public class DTOException {
    private String errType;
    private DTOBase[] constructorArgs;
    private Boolean isBusinessErr = false;

    public DTOException() {
    }

    public DTOException(Exception e) {
        if (e != null) {
            this.errType = e.getClass().getName();
            if (e instanceof BaseRuntimeException) {
                this.isBusinessErr = true;
                BaseRuntimeException bre = (BaseRuntimeException)e;
                DTOBase errorCode = new DTOBase(bre.getErrorCode(), String.class);
                DTOBase errorMsg = new DTOBase(bre.getMessage(), String.class);
                DTOBase[] constructorDTOBase = new DTOBase[]{errorCode, errorMsg};
                this.constructorArgs = constructorDTOBase;
            } else {
                String errMsg = e.getCause() != null ? e.getCause().toString() : e.toString();
                DTOBase[] constructorArgs = new DTOBase[]{new DTOBase(errMsg)};
                this.constructorArgs = constructorArgs;
            }
        }
    }

    public Exception getException() throws Exception {
        Exception err = null;
        if (StringUtils.isNotBlank((String)this.errType)) {
            Class<?> errClass = null;
            try {
                errClass = Class.forName(this.errType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (errClass != null) {
                if (this.constructorArgs != null && this.constructorArgs.length > 0) {
                    Class[] argsType = new Class[this.constructorArgs.length];
                    Object[] argsValue = new Object[this.constructorArgs.length];
                    for (int i = 0; i < this.constructorArgs.length; ++i) {
                        DTOBase dtoBase = this.constructorArgs[i];
                        argsType[i] = dtoBase.getObjectClass();
                        argsValue[i] = dtoBase.getObject();
                    }
                    Constructor<?> con = errClass.getConstructor(argsType);
                    err = (Exception)con.newInstance(argsValue);
                } else {
                    err = (Exception)errClass.newInstance();
                }
            } else {
                StringBuilder errMsg = new StringBuilder();
                if (this.constructorArgs != null && this.constructorArgs.length > 0) {
                    for (DTOBase dtoBase : this.constructorArgs) {
                        errMsg.append(dtoBase.getObjStr());
                        errMsg.append("; ");
                    }
                }
                err = new Exception(errMsg.toString());
            }
        }
        return err;
    }

    public String getErrType() {
        return this.errType;
    }

    public void setErrType(String errType) {
        this.errType = errType;
    }

    public DTOBase[] getConstructorArgs() {
        return this.constructorArgs;
    }

    public void setConstructorArgs(DTOBase[] constructorArgs) {
        this.constructorArgs = constructorArgs;
    }

    public Boolean getIsBusinessErr() {
        return this.isBusinessErr;
    }

    public void setIsBusinessErr(Boolean isBusinessErr) {
        this.isBusinessErr = isBusinessErr;
    }
}

