/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.soaserver.client;

import com.xunlei.netty.soaserver.client.InterfaceProxyBase;
import com.xunlei.netty.soaserver.component.SOAServiceBase;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class SOAClientFactory
implements FactoryBean,
InitializingBean {
    private Class serviceInterface;
    private SOAServiceBase serviceBase;

    public SOAClientFactory(SOAServiceBase serviceBase) {
        this.serviceBase = serviceBase;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public Object getObject() throws Exception {
        return this.getProxyInstance(this.serviceInterface);
    }

    public Object getObject(Class serviceInterface) {
        return this.getProxyInstance(serviceInterface);
    }

    private Object getProxyInstance(Class serviceInterface) {
        InterfaceProxyBase proxyBase = this.newInterfaceProxyBase(serviceInterface);
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceInterface}, (InvocationHandler)proxyBase);
    }

    public InterfaceProxyBase newInterfaceProxyBase(Class serviceInterface) {
        return new InterfaceProxyBase(this.serviceBase, serviceInterface);
    }

    public Class getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class serviceInterface) {
        this.serviceInterface = serviceInterface;
    }
}

