/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.handler;

import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.AbstractHttpServerError;
import com.xunlei.netty.httpserver.handler.TextResponseHandler;
import com.xunlei.netty.util.StringHelper;
import java.util.List;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.springframework.stereotype.Service;

@Service
public class PlainHandler
extends TextResponseHandler {
    public void appendDebugInfo(XLContextAttachment attach, StringBuilder content) {
        XLHttpRequest request;
        if (this.serverConfig.isDebugEnable() && null != (request = attach.getRequest()).getParameter("debug", null)) {
            content.append("\n\n\n---DEBUG---------------------------------------------\n");
            content.append(attach.getName()).append("\n");
            List<Throwable> ts = attach.getThrowables();
            if (null != ts) {
                for (Throwable ex : ts) {
                    StringHelper.printThrowable(content, ex).append("\n\n");
                }
            }
        }
    }

    public StringBuilder _buildContentString(XLContextAttachment attach, Object cmdReturnObj) {
        StringBuilder content = new StringBuilder();
        content.append(cmdReturnObj == null ? this.responseReturnNullInfo : cmdReturnObj);
        this.appendDebugInfo(attach, content);
        return content;
    }

    @Override
    public String buildContentString(XLContextAttachment attach, Object cmdReturnObj) {
        XLHttpResponse response = attach.getResponse();
        response.setHeaderIfEmpty("Content-Type", "text/plain; charset=" + response.getContentCharset());
        StringBuilder content = this._buildContentString(attach, cmdReturnObj);
        return content.toString();
    }

    @Override
    public Object handleThrowable(XLContextAttachment attach, Throwable ex) throws Exception {
        XLHttpResponse response = attach.getResponse();
        XLHttpRequest request = attach.getRequest();
        if (ex instanceof AbstractHttpServerError) {
            HttpResponseStatus status = ((AbstractHttpServerError)ex).getStatus();
            response.setStatus(status);
            return ex.getMessage();
        }
        this.logThrowable(attach, request, response, ex);
        return StringHelper.printThrowableSimple(ex);
    }
}

