/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.util.CharsetTools;
import com.xunlei.netty.util.NettyServerConfig;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class XLHttpResponse
extends DefaultHttpMessage
implements HttpResponse {
    private Charset contentCharset = CharsetTools.UTF_8;
    private int contentLength = -1;
    private boolean contentSetted = false;
    private List<Cookie> cookies = new ArrayList<Cookie>(1);
    private long createTime = System.currentTimeMillis();
    private ContentType innerContentType = NettyServerConfig.getRespInnerContentType();
    private int keepAliveTimeout = NettyServerConfig.getKeepAliveTimeout();
    private boolean keepAliveTimeoutSetted = false;
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private XLContextAttachment attach;

    public XLHttpResponse(XLContextAttachment attach) {
        super(HttpVersion.HTTP_1_1);
        this.attach = attach;
    }

    public XLHttpResponse() {
        super(HttpVersion.HTTP_1_1);
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public Charset getContentCharset() {
        return this.contentCharset;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public ContentType getInnerContentType() {
        return this.innerContentType;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public boolean isContentSetted() {
        return this.contentSetted;
    }

    public void redirect(String localtionUrl) {
        this.setStatus(HttpResponseStatus.FOUND);
        this.setHeaderIfEmpty("Location", localtionUrl);
    }

    public void redirect(String localtionUrl, HttpResponseStatus status) {
        this.setStatus(status);
        this.setHeaderIfEmpty("Location", localtionUrl);
    }

    public void setContent(ChannelBuffer content) {
        super.setContent(content);
        if (content != null) {
            this.contentLength = content.readableBytes();
        }
        this.contentSetted = true;
    }

    public void setContentCharset(Charset contentCharset) {
        this.contentCharset = contentCharset;
    }

    public void setContentString(String contentStr) {
        this.setContent(ChannelBuffers.copiedBuffer((CharSequence)contentStr, (Charset)this.contentCharset));
    }

    public boolean setHeaderIfEmpty(String name, String value) {
        if (this.getHeader(name) == null) {
            this.setHeader(name, value);
            return true;
        }
        return false;
    }

    public void setInnerContentType(ContentType innerContentType) {
        this.innerContentType = innerContentType;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        if (keepAliveTimeout < 0) {
            throw new IllegalArgumentException("keepAliveTimeout:" + keepAliveTimeout + " cant be nagative");
        }
        this.keepAliveTimeoutSetted = true;
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public void setStatus(HttpResponseStatus status) {
        this.status = status;
    }

    public String toString() {
        return this.getProtocolVersion().getText() + ' ' + this.getStatus().toString();
    }

    public void setChunked(boolean chunked) {
        super.setChunked(chunked);
        if (chunked) {
            this.setHeader("Transfer-Encoding", "chunked");
        } else {
            this.removeHeader("Transfer-Encoding");
        }
    }

    public void packagingCookies() {
        List<Cookie> cookies = this.getCookies();
        if (!cookies.isEmpty()) {
            for (Cookie cookie : cookies) {
                CookieEncoder cookieEncoder = new CookieEncoder(true);
                cookieEncoder.addCookie(cookie);
                this.addHeader("Set-Cookie", cookieEncoder.encode());
            }
        }
    }

    public boolean isKeepAliveTimeoutSetted() {
        return this.keepAliveTimeoutSetted;
    }

    public XLContextAttachment getAttach() {
        return this.attach;
    }

    public static enum ContentType {
        html,
        json,
        plain,
        xml,
        lua;

    }
}

