/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NettyServerConfig;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMessageDecoder;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;

public class XLHttpRequestDecoder
extends HttpMessageDecoder {
    private static final String[] httpMethods = new String[]{"GET", "POST", "HEAD", "PUT", "TRACE", "CONNECT", "OPTIONS", "DELETE"};
    private static final int tryLen = 8;
    private static final Logger log = Log.getLogger();

    public static void main(String[] args) {
        ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
        cb.writeBytes("123456GET / HTTP/1.1".getBytes());
        XLHttpRequestDecoder.skipNonHttpMethodCharacters(cb);
    }

    public static void skipNonHttpMethodCharacters(ChannelBuffer buffer) {
        int idx = buffer.readerIndex();
        while (true) {
            byte[] methodTry = new byte[8];
            buffer.readBytes(methodTry);
            String methodTryStr = new String(methodTry).toUpperCase();
            for (String str : httpMethods) {
                if (!Character.isWhitespace((char)methodTry[str.length()]) || !methodTryStr.startsWith(str)) continue;
                int len = buffer.readerIndex() - 8 - idx;
                if (len > 0) {
                    byte[] bytes = new byte[len];
                    buffer.readerIndex(idx);
                    buffer.readBytes(bytes);
                    String skipString = new String(bytes);
                    log.warn("{}", (Object)skipString);
                } else {
                    buffer.readerIndex(buffer.readerIndex() - 8);
                }
                return;
            }
            buffer.readerIndex(buffer.readerIndex() + 1 - 8);
        }
    }

    public XLHttpRequestDecoder(NettyServerConfig config) {
        super(4096, 65536, 65536);
    }

    protected boolean isDecodingRequest() {
        return true;
    }

    protected HttpMessage createMessage(String[] initialLine) throws Exception {
        HttpMethod httpMethod = HttpMethod.valueOf((String)initialLine[0]);
        try {
            return new XLHttpRequest(HttpVersion.valueOf((String)initialLine[2]), httpMethod, initialLine[1]);
        }
        catch (Exception e) {
            String fix = initialLine[1] + " " + initialLine[2];
            int result = 0;
            for (result = fix.length(); result > 0 && !Character.isWhitespace(fix.charAt(result - 1)); --result) {
            }
            String version = fix.substring(result);
            while (result > 0 && Character.isWhitespace(fix.charAt(result - 1))) {
                --result;
            }
            String uri = fix.substring(0, result);
            String errorMsg = String.format("parse httpRequest initialLine fail!\n\tori:{%s}\n\t      fix:{%s}\n\t      uri:{%s}\n\t  version:{%s}\n\t{%s}", Arrays.toString(initialLine), fix, uri, version, e.getMessage());
            log.error(errorMsg, (Throwable)e);
            return new XLHttpRequest(HttpVersion.valueOf((String)version), httpMethod, uri);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }
}

