/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.xunlei.netty.httpserver.cmd.BaseCmd;
import com.xunlei.netty.httpserver.cmd.CmdMappers;
import com.xunlei.netty.httpserver.component.BasePageDispatcher;
import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.ResourceNotFoundError;
import com.xunlei.netty.httpserver.handler.TextResponseHandlerManager;
import com.xunlei.netty.util.IPAuthenticator;
import com.xunlei.netty.util.IPGetterHelper;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.StringTools;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CmdMapperDispatcher
extends BasePageDispatcher {
    private static final Logger log = Log.getLogger();
    @Autowired
    protected TextResponseHandlerManager handlerManager;

    protected Object _dispatch(XLContextAttachment attach) throws Exception {
        XLHttpRequest request = attach.getRequest();
        XLHttpResponse response = attach.getResponse();
        String path = request.getPath();
        log.debug("Netty\u670d\u52a1.Http\u8bf7\u6c42.path=" + path);
        CmdMappers.CmdMeta meta = this.cmdMappers.getCmdMeta(path);
        if (meta == null) {
            throw ResourceNotFoundError.INSTANCE;
        }
        attach.setCmdMeta(meta);
        if (meta.isDisable()) {
            throw ResourceNotFoundError.INSTANCE;
        }
        if (meta.isAdmin()) {
            IPAuthenticator.auth(request);
        }
        BaseCmd cmd = meta.getCmd();
        Method method = meta.getMethod();
        Transaction t = Cat.newTransaction((String)"URL", (String)path);
        t.addData("clientIp", (Object)IPGetterHelper.getRequestIp(request));
        t.addData("Referer", (Object)request.getHeaders("Referer"));
        t.addData("Uri", (Object)request.getUri());
        t.addData("userid", (Object)request.getCookieValue("userid", ""));
        t.addData("sessionid", (Object)request.getCookieValue("sessionid", ""));
        String rtnName = request.getParameter("rtnName");
        try {
            if (StringUtils.isNotEmpty((String)rtnName) && !StringTools.checkNonSpecialCharacter(rtnName)) {
                log.warn("rtnName\u4e3a\u975e\u6cd5\u5b57\u6bb5[" + rtnName + "]");
                String string = "rtnName\u4e3a\u975e\u6cd5\u5b57\u6bb5";
                return string;
            }
            attach.registerProcessThread();
            cmd.processBegin(request, response);
            Object resultObj = null;
            Transaction t_invoke = Cat.newTransaction((String)"Other", (String)(path + "_invoke"));
            try {
                resultObj = method.invoke((Object)cmd, new Object[]{request, response});
                t_invoke.setStatus("0");
            }
            catch (Exception e) {
                t_invoke.setStatus("0");
                throw e;
            }
            finally {
                t_invoke.complete();
            }
            cmd.processEnd(request, response, resultObj);
            t.setStatus("0");
            Object object = resultObj;
            return object;
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            if (StringUtils.isNotBlank((String)e.getMessage())) {
                Cat.logError((String)e.getMessage(), (Throwable)e);
            } else {
                Cat.logError((Throwable)e);
            }
            throw e;
        }
        finally {
            t.complete();
            attach.unregisterProcessThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispatch(XLContextAttachment attach) throws Exception {
        attach.checkChannelOrThread();
        Object cmdReturnObj = null;
        try {
            cmdReturnObj = this._dispatch(attach);
        }
        catch (Throwable ex) {
            cmdReturnObj = this.handlerManager.handleThrowable(attach, ex);
        }
        finally {
            String cmdReturnStr = "Obj return Null";
            if (cmdReturnObj != null) {
                cmdReturnStr = cmdReturnObj.toString();
            }
            log.debug("Netty\u670d\u52a1.Http\u8bf7\u6c42.\u8fd4\u56de\u503ccmdReturnObj=" + cmdReturnStr);
            this.handlerManager.writeResponse(attach, cmdReturnObj);
        }
    }

    @Override
    public void init() throws Exception {
        log.debug("Netty\u670d\u52a1.\u521d\u59cb\u5316Url\u6620\u5c04.cmdMappers.initAutoMap()");
        this.cmdMappers.initAutoMap();
        log.debug("Netty\u670d\u52a1.\u91cd\u7f6eCMD\u914d\u7f6e,\u540e\u53f0\u626b\u63cf\u5668\uff0c\u8d85\u65f6\u529f\u80fd\u662f\u5426\u542f\u8fd0.cmdMappers.resetCmdConfig()");
        this.cmdMappers.resetCmdConfig();
    }
}

