/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.grpcserver.nameresolver;

import com.google.common.base.Preconditions;
import com.xunlei.netty.grpcserver.nameresolver.ConsulNameResolver;
import com.xunlei.netty.soaserver.component.SOAServiceBase;
import io.grpc.Attributes;
import io.grpc.NameResolverProvider;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public final class ConsulNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "consul";
    private ConsulNameResolver consulNameResolver;
    private SOAServiceBase soaServiceBase;

    public ConsulNameResolverProvider(SOAServiceBase soaServiceBase) {
        this.soaServiceBase = soaServiceBase;
    }

    public ConsulNameResolver newNameResolver(URI targetUri, Attributes params) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getPath(), (Object)"targetPath");
            String name = targetUri.getAuthority();
            this.consulNameResolver = new ConsulNameResolver(targetUri.getAuthority(), name, params, (SharedResourceHolder.Resource<ScheduledExecutorService>)GrpcUtil.TIMER_SERVICE, (SharedResourceHolder.Resource<ExecutorService>)GrpcUtil.SHARED_CHANNEL_EXECUTOR, this.soaServiceBase);
            return this.consulNameResolver;
        }
        return null;
    }

    public String getDefaultScheme() {
        return SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 5;
    }

    public ConsulNameResolver getConsulNameResolver() {
        return this.consulNameResolver;
    }
}

