/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.grpcserver.nameresolver;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.ecwid.consul.v1.health.model.HealthService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xunlei.netty.consul.ConsulFactory;
import com.xunlei.netty.consul.service.ServiceClient;
import com.xunlei.netty.soaserver.component.SOAServiceBase;
import com.xunlei.netty.util.GRPCServerHelper;
import com.xunlei.netty.util.Log;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.ResolvedServerInfo;
import io.grpc.Status;
import io.grpc.internal.LogExceptionRunnable;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class ConsulNameResolver
extends NameResolver {
    private static final Logger log = Log.getLogger();
    private final String authority;
    private final String serviceName;
    private final SharedResourceHolder.Resource<ScheduledExecutorService> timerServiceResource;
    private final SharedResourceHolder.Resource<ExecutorService> executorResource;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private ScheduledExecutorService timerService;
    @GuardedBy(value="this")
    private ExecutorService executor;
    @GuardedBy(value="this")
    private ScheduledFuture<?> resolutionTask;
    @GuardedBy(value="this")
    private boolean resolving;
    @GuardedBy(value="this")
    private NameResolver.Listener listener;
    private List<InetSocketAddress> availableServiceList = new ArrayList<InetSocketAddress>();
    private final Object lock = new Object();
    private SOAServiceBase soaServiceBase;
    private final Runnable resolutionRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NameResolver.Listener savedListener;
            Transaction t = Cat.newTransaction((String)"GRPC", (String)"ConsulNameResolver.resolutionRunnable");
            t.addData("serviceName", (Object)ConsulNameResolver.this.serviceName);
            ConsulNameResolver consulNameResolver = ConsulNameResolver.this;
            synchronized (consulNameResolver) {
                if (ConsulNameResolver.this.shutdown) {
                    return;
                }
                savedListener = ConsulNameResolver.this.listener;
                ConsulNameResolver.this.resolving = true;
            }
            try {
                if (this.isServiceListUpdate()) {
                    if (ConsulNameResolver.this.availableServiceList != null && ConsulNameResolver.this.availableServiceList.size() > 0) {
                        ArrayList asList = new ArrayList(ConsulNameResolver.this.availableServiceList.size());
                        asList.addAll(ConsulNameResolver.this.availableServiceList);
                        ArrayList serverList = new ArrayList(ConsulNameResolver.this.availableServiceList.size());
                        ArrayList<ResolvedServerInfo> servers = null;
                        Iterator i$ = asList.iterator();
                        while (i$.hasNext()) {
                            InetSocketAddress inetSocketAddress = (InetSocketAddress)i$.next();
                            servers = new ArrayList<ResolvedServerInfo>(1);
                            servers.add(new ResolvedServerInfo((SocketAddress)inetSocketAddress, Attributes.EMPTY));
                            serverList.add(servers);
                        }
                        savedListener.onUpdate(serverList, Attributes.EMPTY);
                    } else {
                        savedListener.onError(Status.UNAVAILABLE.withCause((Throwable)new Exception("\u670d\u52a1\u53ef\u7528\u5217\u8868\u4e3a\u7a7a")));
                    }
                }
                t.setStatus("0");
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                log.error("GRPC.ConsulNameResolver.resolutionRunnable.\u5f02\u5e38", (Throwable)e);
            }
            finally {
                t.complete();
                ConsulNameResolver consulNameResolver2 = ConsulNameResolver.this;
                synchronized (consulNameResolver2) {
                    ConsulNameResolver.this.resolving = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isServiceListUpdate() {
            ArrayList<InetSocketAddress> consullist = null;
            Map<String, Integer> healthServiceList = null;
            if (ConsulNameResolver.this.soaServiceBase.isConsulIsEnable()) {
                healthServiceList = ConsulNameResolver.this.getServiceList(ConsulNameResolver.this.serviceName);
            } else if (StringUtils.isNotBlank((String)ConsulNameResolver.this.soaServiceBase.getGrpcServiceHost()) && ConsulNameResolver.this.soaServiceBase.getGrpcServicePort() > 0) {
                healthServiceList = new HashMap<String, Integer>(1);
                healthServiceList.put(ConsulNameResolver.this.soaServiceBase.getGrpcServiceHost(), ConsulNameResolver.this.soaServiceBase.getGrpcServicePort());
            }
            if (healthServiceList == null) {
                return false;
            }
            if (healthServiceList.size() > 0) {
                consullist = new ArrayList<InetSocketAddress>(healthServiceList.size());
                for (Map.Entry<String, Integer> service : healthServiceList.entrySet()) {
                    InetSocketAddress socketAddress = new InetSocketAddress(service.getKey(), (int)service.getValue());
                    consullist.add(socketAddress);
                }
            }
            if (!GRPCServerHelper.equalsList(consullist, ConsulNameResolver.this.availableServiceList)) {
                Object object = ConsulNameResolver.this.lock;
                synchronized (object) {
                    if (!GRPCServerHelper.equalsList(consullist, ConsulNameResolver.this.availableServiceList)) {
                        ConsulNameResolver.this.availableServiceList.clear();
                        if (consullist != null && consullist.size() > 0) {
                            ConsulNameResolver.this.availableServiceList.addAll(consullist);
                        }
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
    };
    private final Runnable resolutionRunnableOnExecutor = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConsulNameResolver consulNameResolver = ConsulNameResolver.this;
            synchronized (consulNameResolver) {
                if (!ConsulNameResolver.this.shutdown) {
                    ConsulNameResolver.this.executor.execute(ConsulNameResolver.this.resolutionRunnable);
                }
            }
        }
    };

    ConsulNameResolver(@Nullable String nsAuthority, String name, Attributes params, SharedResourceHolder.Resource<ScheduledExecutorService> timerServiceResource, SharedResourceHolder.Resource<ExecutorService> executorResource, SOAServiceBase soaServiceBase) {
        this.timerServiceResource = timerServiceResource;
        this.executorResource = executorResource;
        URI nameUri = URI.create("//" + name);
        this.authority = (String)Preconditions.checkNotNull((Object)nameUri.getAuthority(), (String)"nameUri (%s) doesn't have an authority", (Object[])new Object[]{nameUri});
        this.serviceName = name;
        this.soaServiceBase = soaServiceBase;
    }

    public final String getServiceAuthority() {
        return this.authority;
    }

    public final synchronized void start(NameResolver.Listener listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.timerService = (ScheduledExecutorService)SharedResourceHolder.get(this.timerServiceResource);
        this.executor = (ExecutorService)SharedResourceHolder.get(this.executorResource);
        this.listener = (NameResolver.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.resolve();
        if (this.soaServiceBase.isConsulIsEnable()) {
            this.resolutionTask = this.timerService.scheduleAtFixedRate((Runnable)new LogExceptionRunnable(this.resolutionRunnableOnExecutor), ServiceClient.getCheckInterval(), ServiceClient.getCheckInterval(), TimeUnit.SECONDS);
        }
    }

    public final synchronized void refresh() {
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"not started");
        this.resolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Map<String, Integer> getServiceList(String serviceName) {
        HashMap<String, Integer> serviceMap = null;
        Transaction t = Cat.newTransaction((String)"GRPC", (String)"ConsulNameResolver.getServiceList");
        t.addData("serviceName", (Object)serviceName);
        try {
            List hsList;
            if (StringUtils.isNotBlank((String)serviceName) && (hsList = (List)ConsulFactory.getInstance().getConsulClient().getHealthServices(serviceName, true, null).getValue()) != null && hsList.size() > 0) {
                serviceMap = new HashMap<String, Integer>();
                for (HealthService healthService : hsList) {
                    if (serviceMap.containsKey(healthService.getService().getAddress())) continue;
                    serviceMap.put(healthService.getService().getAddress(), healthService.getService().getPort());
                }
            }
            t.setStatus("0");
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            log.error("GRPC.ConsulNameResolver.getServiceList.\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        finally {
            t.complete();
        }
        return serviceMap;
    }

    @GuardedBy(value="this")
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.executor.execute(this.resolutionRunnable);
    }

    public final synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.resolutionTask != null) {
            this.resolutionTask.cancel(false);
        }
        if (this.timerService != null) {
            this.timerService = (ScheduledExecutorService)SharedResourceHolder.release(this.timerServiceResource, (Object)this.timerService);
        }
        if (this.executor != null) {
            this.executor = (ExecutorService)SharedResourceHolder.release(this.executorResource, (Object)this.executor);
        }
    }
}

