/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.grpcserver.interceptor;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import com.xunlei.netty.exception.BusinessRuntimeException;
import com.xunlei.netty.util.GRPCServerHelper;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.spring.BeanUtil;
import com.xunlei.niux.common.util.IPUtil;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import org.slf4j.Logger;

public class CatServerInterceptor
implements ServerInterceptor {
    private static final Logger log = Log.getLogger();
    private static NettyServerConfig serverConfig = BeanUtil.getTypedBean(NettyServerConfig.class);

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void sendHeaders(Metadata responseHeaders) {
                String serviceIP = IPUtil.getLocalHostAddress();
                String servicePort = "";
                if (serverConfig != null) {
                    servicePort = serverConfig.getListen_grpc_port() + "";
                }
                responseHeaders.put(GRPCServerHelper.MDKey_ServiceIPKey, (Object)serviceIP);
                responseHeaders.put(GRPCServerHelper.MDKey_ServicePortKey, (Object)servicePort);
                super.sendHeaders(responseHeaders);
            }
        }, headers)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onHalfClose() {
                Transaction t = Cat.newTransaction((String)"PigeonService", (String)call.getMethodDescriptor().getFullMethodName());
                String clientIP = "";
                if (headers.containsKey(GRPCServerHelper.MDKey_ClientIP)) {
                    clientIP = (String)headers.get(GRPCServerHelper.MDKey_ClientIP);
                }
                t.addData("ClientIp", (Object)clientIP);
                t.addData("ServerIp", (Object)IPUtil.getLocalHostAddress());
                Cat.logEvent((String)"PigeonService.client", (String)clientIP);
                String appName = "";
                if (serverConfig != null) {
                    appName = (String)headers.get(GRPCServerHelper.MDKey_ClientAppName);
                }
                Cat.logEvent((String)"PigeonService.app", (String)appName);
                MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
                if (headers.containsKey(GRPCServerHelper.MDKey_ChildId)) {
                    tree.setMessageId((String)headers.get(GRPCServerHelper.MDKey_ChildId));
                }
                if (headers.containsKey(GRPCServerHelper.MDKey_RootMessageId)) {
                    tree.setRootMessageId((String)headers.get(GRPCServerHelper.MDKey_RootMessageId));
                }
                if (headers.containsKey(GRPCServerHelper.MDKey_MessageId)) {
                    tree.setParentMessageId((String)headers.get(GRPCServerHelper.MDKey_MessageId));
                }
                Status status = Status.OK;
                Metadata metadata = new Metadata();
                try {
                    this.delegate().onHalfClose();
                    if (call.isCancelled()) {
                        throw Status.CANCELLED.asRuntimeException();
                    }
                    t.setStatus("0");
                }
                catch (BusinessRuntimeException e) {
                    t.setStatus("0");
                    status = Status.INTERNAL;
                    metadata = GRPCServerHelper.getMetadataFromException(e);
                    log.warn("GRPCServer.CatServerInterceptor.onHalfClose.\u544a\u8b66:" + GRPCServerHelper.getExceptionStringFromMetadata(metadata), (Throwable)e);
                }
                catch (Exception e) {
                    t.setStatus((Throwable)e);
                    status = Status.fromThrowable((Throwable)e);
                    Metadata trailers = Status.trailersFromThrowable((Throwable)e);
                    metadata = trailers == null ? GRPCServerHelper.getMetadataFromException(e) : trailers;
                    log.error("GRPCServer.CatServerInterceptor.onHalfClose.\u5f02\u5e38:" + GRPCServerHelper.getExceptionStringFromMetadata(metadata), (Throwable)e);
                }
                finally {
                    t.complete();
                    status.withDescription(metadata.toString());
                    try {
                        call.close(status, metadata);
                    }
                    catch (Exception e2) {
                        log.error("GRPCServer.CatServerInterceptor.onHalfClose.close\u5f02\u5e38.MethodName:" + call.getMethodDescriptor().getFullMethodName() + ";", (Throwable)e2);
                    }
                }
            }

            public void onComplete() {
                Transaction t = Cat.newTransaction((String)"GRPC", (String)"GRPCServer.CatServerInterceptor.onComplete");
                t.addData("FullMethodName", (Object)call.getMethodDescriptor().getFullMethodName());
                super.onComplete();
                t.setStatus("0");
                t.complete();
            }

            public void onMessage(ReqT message) {
                Transaction t = Cat.newTransaction((String)"GRPC", (String)"GRPCServer.CatServerInterceptor.onMessage");
                t.addData("FullMethodName", (Object)call.getMethodDescriptor().getFullMethodName());
                super.onMessage(message);
                t.setStatus("0");
                t.complete();
            }

            public void onReady() {
                Transaction t = Cat.newTransaction((String)"GRPC", (String)"GRPCServer.CatServerInterceptor.onReady");
                t.addData("FullMethodName", (Object)call.getMethodDescriptor().getFullMethodName());
                super.onReady();
                t.setStatus("0");
                t.complete();
            }

            public void onCancel() {
                Transaction t = Cat.newTransaction((String)"GRPC", (String)"GRPCServer.CatServerInterceptor.onCancel");
                t.addData("FullMethodName", (Object)call.getMethodDescriptor().getFullMethodName());
                super.onCancel();
                t.setStatus("0");
                t.complete();
            }
        };
    }
}

