/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.grpcserver.cmd;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.netty.exception.BusinessRuntimeException;
import com.xunlei.netty.httpserver.cmd.BaseCmd;
import com.xunlei.netty.httpserver.model.CookieInfo;
import com.xunlei.netty.soaserver.cmd.BaseSOACmd;
import com.xunlei.util.Log;
import java.util.Map;
import org.jboss.netty.util.internal.ConcurrentHashMap;
import org.slf4j.Logger;

public class BaseGRPCCmd
extends BaseSOACmd {
    private static Logger logger = Log.getLogger((String)BaseGRPCCmd.class.getName());
    public static final BaseGRPCCmd INSTANCE = new BaseGRPCCmd();
    private JsonFormat protoJson = new JsonFormat();
    private Gson gson = new Gson();
    private Map<Class<?>, Schema<?>> protostuffSchema = new ConcurrentHashMap();

    public void mergeBuilderByHTTP(GeneratedMessageV3.Builder<?> builder, BaseCmd httpCmd, String methodName, Map<String, String> param) throws Exception {
        this.mergeBuilderByHTTP(builder, httpCmd, methodName, param, null);
    }

    public void mergeBuilderByHTTP(GeneratedMessageV3.Builder<?> builder, BaseCmd httpCmd, String methodName, Map<String, String> param, CookieInfo cookieInfo) throws Exception {
        JsonObject jsonObject = this.getHTTPMethodJsonObjectWithCookie(httpCmd, methodName, param, cookieInfo);
        if (jsonObject != null) {
            int code = jsonObject.get("rtn").getAsInt();
            if (code != 0) {
                String msg = jsonObject.get("data").getAsString();
                throw new BusinessRuntimeException(code + "", msg);
            }
        } else {
            throw new XLRuntimeException("jsonObject\u4e3a\u7a7a");
        }
        String str = jsonObject.get("data").toString();
        this.protoJson.merge((CharSequence)str, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public JsonObject getHTTPMethodJsonObjectWithCookie(BaseCmd httpCmd, String methodName, Map<String, String> param, CookieInfo cookieInfo) throws Exception {
        JsonObject jsonObject = null;
        Object resultMsg = this.getHTTPMethodResultWithCookie(httpCmd, methodName, param, cookieInfo);
        if (resultMsg != null) {
            String resultMsgStr = resultMsg.toString().trim();
            if (!resultMsgStr.startsWith("{")) {
                resultMsgStr = resultMsgStr.substring(resultMsgStr.indexOf("{"), resultMsgStr.length() - 1);
            }
            jsonObject = new JsonParser().parse(resultMsgStr).getAsJsonObject();
        }
        return jsonObject;
    }

    public <T> byte[] serializeProtobuf(T obj) {
        Class<?> cls = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            Schema<?> schema = this.getProtostuffSchema(cls);
            byte[] byArray = ProtostuffIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            buffer.clear();
        }
    }

    public <T> T deserializeProtobuf(GeneratedMessageV3 request, Class<T> cls) {
        return (T)this.gson.fromJson(this.protoJson.printToString((Message)request), cls);
    }

    private <T> Schema<T> getProtostuffSchema(Class<T> cls) {
        RuntimeSchema schema = this.protostuffSchema.get(cls);
        if (schema == null && (schema = RuntimeSchema.createFrom(cls)) != null) {
            this.protostuffSchema.put(cls, (Schema<?>)schema);
        }
        return schema;
    }
}

