/**
 * 
 */
package com.xunlei.netty.util;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.xunlei.netty.exception.BaseRuntimeException;
import com.xunlei.netty.grpcserver.nameresolver.ConsulNameResolverProvider;

import io.grpc.CallOptions;
import io.grpc.Metadata;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;

/**
 * GRPC 服务常量
 * 
 * @author wangcanyi
 *
 */
public class GRPCServerHelper {
	/**
	 * 客户端IP地址
	 */
	public final static Metadata.Key<String> MDKey_ClientIP = Metadata.Key.of("MDKey_ClientIP", Metadata.ASCII_STRING_MARSHALLER);
	/**
	 * 客户端应用名
	 */
	public final static Metadata.Key<String> MDKey_ClientAppName = Metadata.Key.of("MDKey_ClientAppName", Metadata.ASCII_STRING_MARSHALLER);
	/**
	 * Cat Child 消息Id
	 */
	public final static Metadata.Key<String> MDKey_ChildId = Metadata.Key.of("MDKey_ChildId", Metadata.ASCII_STRING_MARSHALLER);
	/**
	 * Cat 根 消息Id
	 */
	public final static Metadata.Key<String> MDKey_RootMessageId = Metadata.Key.of("MDKey_RootMessageId", Metadata.ASCII_STRING_MARSHALLER);
	/**
	 * Cat 消息Id
	 */
	public final static Metadata.Key<String> MDKey_MessageId = Metadata.Key.of("MDKey_MessageId", Metadata.ASCII_STRING_MARSHALLER);
	/**
	 * 服务端IP地址
	 */
	public final static Metadata.Key<String> MDKey_ServiceIPKey = Metadata.Key.of("MDKey_ServiceIPKey", Metadata.ASCII_STRING_MARSHALLER);
	/**
	 * 服务端端口
	 */
	public final static Metadata.Key<String> MDKey_ServicePortKey = Metadata.Key.of("MDKey_ServicePortKey", Metadata.ASCII_STRING_MARSHALLER);
	/**
	 * 异常错误码
	 */
	public final static Metadata.Key<String> MDKey_ErrorCode = Metadata.Key.of("MDKey_ErrorCode", Metadata.ASCII_STRING_MARSHALLER);
	/**
	 * 异常错误信息
	 */
	public final static Metadata.Key<byte[]> MDKey_ErrorMsg = Metadata.Key.of("MDKey_ErrorMsg-bin", Metadata.BINARY_BYTE_MARSHALLER);

	/**
	 * 是否异常接口
	 */
	public final static CallOptions.Key<Boolean> COKey_IsAsyncInterface = CallOptions.Key.of("COKey_IsAsyncInterface", false);

	/**
	 * 接口连接超时时间,单位毫秒
	 */
	public final static CallOptions.Key<Long> COKey_ConnectionTimeout = CallOptions.Key.of("COKey_ConnectionTimeout", 0L);

	/**
	 * 获取异常信息Metadata
	 * 
	 * @param e
	 * @return
	 */
	public static Metadata getMetadataFromException(Exception e) {
		Metadata metadata = new Metadata();
		if (e != null) {
			String code = "";
			String msg = "";
			if (e instanceof BaseRuntimeException) {
				code = ((BaseRuntimeException) e).getErrorCode();
				msg = ((BaseRuntimeException) e).getMessage();
			} else {
				if (StringUtils.isNotBlank(e.getMessage()))
					msg = e.getMessage();
			}
			metadata.put(GRPCServerHelper.MDKey_ErrorCode, code);
			metadata.put(GRPCServerHelper.MDKey_ErrorMsg, msg.getBytes());
		}
		return metadata;
	}

	/**
	 * 获取异常信息 根据元数据
	 * 
	 * @param metadata
	 * @return
	 */
	public static String getExceptionStringFromMetadata(Metadata metadata) {
		String exStr = "";
		if (metadata != null) {
			if (metadata.containsKey(MDKey_ErrorCode))
				exStr += "ErrorCode:" + metadata.get(MDKey_ErrorCode) + ";";
			if (metadata.containsKey(MDKey_ErrorMsg))
				exStr += "ErrorMsg:" + new String(metadata.get(MDKey_ErrorMsg)) + ";";
		}
		return exStr;
	}

	/**
	 * 获取异常信息 根据 GRPC异常
	 * 
	 * @param e
	 * @return
	 */
	public static String getExceptionStringFromException(Exception e) {
		String exStr = "";
		if (e != null) {
			exStr = e.getMessage();
			if (e instanceof StatusException)
				exStr = exStr + ";" + getExceptionStringFromMetadata(((StatusException) e).getTrailers());
			else if (e instanceof StatusRuntimeException)
				exStr = exStr + ";" + getExceptionStringFromMetadata(((StatusRuntimeException) e).getTrailers());
		}
		return exStr;
	}

	/**
	 * 获取异常号 根据 GRPC异常
	 * 
	 * @param e
	 * @return
	 */
	public static String getExceptionCodeFromException(Exception e) {
		String exCode = "";
		if (e != null) {
			Metadata metadata = null;
			if (e instanceof StatusException)
				metadata = ((StatusException) e).getTrailers();
			else if (e instanceof StatusRuntimeException)
				metadata = ((StatusRuntimeException) e).getTrailers();
			if (metadata != null)
				exCode = metadata.get(MDKey_ErrorCode);
		}
		return exCode;
	}

	/**
	 * 获取异常消息 根据 GRPC异常
	 * 
	 * @param e
	 * @return
	 */
	public static String getExceptionMsgFromException(Exception e) {
		String exMsg = "";
		if (e != null) {
			Metadata metadata = null;
			if (e instanceof StatusException)
				metadata = ((StatusException) e).getTrailers();
			else if (e instanceof StatusRuntimeException)
				metadata = ((StatusRuntimeException) e).getTrailers();
			if (metadata != null && metadata.containsKey(MDKey_ErrorMsg))
				exMsg = new String(metadata.get(MDKey_ErrorMsg));
			else
				exMsg = e.getMessage();
		}
		return exMsg;
	}

	/**
	 * 验证两集合是否相等
	 * 
	 * @param list1
	 * @param list2
	 * @return
	 */
	public static boolean equalsList(List<?> list1, List<?> list2) {
		if ((list1 == null || list1.size() == 0) && (list2 == null || list2.size() == 0))
			return true;
		if (list1 != null && list2 != null) {
			if (list1.size() == list2.size()) {
				if (list1.containsAll(list2) && list2.containsAll(list1))
					return true;
			}
		}
		return false;
	}
}
