/**
 * 
 */
package com.xunlei.netty.soaserver.component;

import java.util.List;

/**
 * SOA服务接口响应分页类
 * 
 * @author wangcanyi
 *
 */
public class SOAPageResponse<T> extends SOAResponse<T> {

	/**
	 * @param genericType 泛型类型
	 */
	public SOAPageResponse(Class<?> genericType) {
		super(genericType);
	}

	private List<T> pageDatas;
	private int totalCount;

	/**
	 * @return 列表数据
	 */
	public List<T> getPageDatas() {
		return pageDatas;
	}

	/**
	 * @param pageDatas 列表数据
	 */
	public void setPageDatas(List<T> pageDatas) {
		this.pageDatas = pageDatas;
	}

	/**
	 * @return 总数
	 */
	public int getTotalCount() {
		return totalCount;
	}

	/**
	 * @param totalCount 列表数据
	 */
	public void setTotalCount(int totalCount) {
		this.totalCount = totalCount;
	}

	/**
	 * @return 列表数据的第一个数据
	 */
	@Override
	public T getData() {
		if (this.pageDatas != null && this.pageDatas.size() > 0) {
			this.setData(this.pageDatas.get(0));
		}
		return super.getData();
	}
}
