/**
 * 
 */
package com.xunlei.netty.soaserver.component;

import java.util.List;

/**
 * SOA服务接口响应分页类
 * 
 * @author wangcanyi
 *
 */
public class SOAListResponse<T> extends SOAResponse<T> {

	/**
	 * @param genericType 泛型类型
	 */
	public SOAListResponse(Class<?> genericType) {
		super(genericType);
	}

	private List<T> dataList;


	/**
	 * @return 列表数据
	 */
	public List<T> getDataList() {
		return dataList;
	}

	/**
	 * @param dataList 列表数据
	 */
	public void setDataList(List<T> dataList) {
		this.dataList = dataList;
	}
	/**
	 * @return 列表数据的第一个数据
	 */
	@Override
	public T getData() {
		if (this.dataList != null && this.dataList.size() > 0) {
			this.setData(this.dataList.get(0));
		}
		return super.getData();
	}
}
