package com.xunlei.netty.soaserver.component;

/**
 * Rpc 对象输入
 * 
 * @author wangcanyi
 *
 */
public class RpcInput extends RpcObjectBase {
	private DTOBase retObjBase;
	private DTOException error;
	private Boolean isSuccess = true;

	/**
	 * @return 返回数据
	 */
	public DTOBase getRetObjBase() {
		return retObjBase;
	}

	/**
	 * @param retObjBase 返回数据
	 */
	public void setRetObjBase(DTOBase retObjBase) {
		this.retObjBase = retObjBase;
	}

	/**
	 * @return 异常
	 */
	public DTOException getError() {
		return error;
	}

	/**
	 * @param error 异常
	 */
	public void setError(DTOException error) {
		this.error = error;
	}

	/**
	 * @return 是否请求成功
	 */
	public Boolean getIsSuccess() {
		return isSuccess;
	}

	/**
	 * @param isSuccess 是否请求成功
	 */
	public void setIsSuccess(Boolean isSuccess) {
		this.isSuccess = isSuccess;
	}

	/**
	 * 设置返回对象
	 * 
	 * @param retObj
	 */
	public void setRetObj(Object retObj) {
		if (retObj != null) {
			this.retObjBase = new DTOBase(retObj);
		}
	}

	/**
	 * 获取返回对象
	 * 
	 * @return
	 * @throws Exception
	 */
	public Object getRetObj() throws Exception {
		Object retObj = null;
		if (this.retObjBase != null) {
			retObj = this.retObjBase.getObject();
		}
		return retObj;
	}

	/**
	 * 设置异常
	 * 
	 * @param e
	 */
	public void setException(Exception e) {
		if (e != null) {
			this.error = new DTOException(e);
			if (!this.error.getIsBusinessErr().booleanValue())// 当有异常时，且为非业务异常时，认为请求失败
				this.isSuccess = false;
		}
	}
}
