/**
 * 
 */
package com.xunlei.netty.soaserver.component;

import java.lang.reflect.Constructor;

import org.apache.commons.lang.StringUtils;

import com.xunlei.netty.exception.BaseRuntimeException;

/**
 * 数据传输异常
 * 
 * @author wangcanyi
 *
 */
public class DTOException {
	private String errType;
	private DTOBase[] constructorArgs;
	private Boolean isBusinessErr = false;

	/**
	 * 无参数构造
	 */
	public DTOException() {

	}

	/**
	 * 参数构造
	 * 
	 * @param e
	 */
	public DTOException(Exception e) {
		if (e != null) {
			this.errType = e.getClass().getName();
			if (e instanceof BaseRuntimeException) {
				this.isBusinessErr = true;// 业务异常
				BaseRuntimeException bre = ((BaseRuntimeException) e);
				DTOBase errorCode = new DTOBase(bre.getErrorCode(), String.class);
				DTOBase errorMsg = new DTOBase(bre.getMessage(), String.class);
				DTOBase[] constructorDTOBase = { errorCode, errorMsg };
				this.constructorArgs = constructorDTOBase;
			} else {
				// invoke 反射拿异常信息，需要使用e.getCause().getMessage()
				String errMsg = e.getCause() != null ? e.getCause().toString() : e.toString();
				DTOBase[] constructorArgs = { new DTOBase(errMsg) };
				this.constructorArgs = constructorArgs;
			}
		}
	}

	/**
	 * 获取异常
	 * 
	 * @return
	 * @throws Exception
	 */
	public Exception getException() throws Exception {
		Exception err = null;
		if (StringUtils.isNotBlank(this.errType)) {
			Class<?> errClass = null;
			try {
				errClass = Class.forName(this.errType);
			} catch (ClassNotFoundException e) {
			}
			if (errClass != null) {// 存在异常类，实例出异常类
				if (this.constructorArgs != null && this.constructorArgs.length > 0) {// 有参数构造
					Class<?>[] argsType = new Class<?>[this.constructorArgs.length];
					Object[] argsValue = new Object[this.constructorArgs.length];
					for (int i = 0; i < this.constructorArgs.length; i++) {
						DTOBase dtoBase = this.constructorArgs[i];
						argsType[i] = dtoBase.getObjectClass();
						argsValue[i] = dtoBase.getObject();
					}
					Constructor<?> con = errClass.getConstructor(argsType);
					err = (Exception) con.newInstance(argsValue);
				} else {// 无参数默认构造
					err = (Exception) errClass.newInstance();
				}
			} else {// 不存在异常类时，实例默认异常
				StringBuilder errMsg = new StringBuilder();
				if (this.constructorArgs != null && this.constructorArgs.length > 0) {
					for (DTOBase dtoBase : constructorArgs) {
						errMsg.append(dtoBase.getObjStr());
						errMsg.append("; ");
					}
				}
				err = new Exception(errMsg.toString());
			}
		}
		return err;
	}

	/**
	 * @return 异常类型
	 */
	public String getErrType() {
		return errType;
	}

	/**
	 * @param errType 异常类型
	 */
	public void setErrType(String errType) {
		this.errType = errType;
	}

	/**
	 * @return 构造器参数
	 */
	public DTOBase[] getConstructorArgs() {
		return constructorArgs;
	}

	/**
	 * @param constructorArgs 构造器参数
	 */
	public void setConstructorArgs(DTOBase[] constructorArgs) {
		this.constructorArgs = constructorArgs;
	}

	/**
	 * @return 是否业务异常
	 */
	public Boolean getIsBusinessErr() {
		return isBusinessErr;
	}

	/**
	 * @param isBusinessErr 是否业务异常
	 */
	public void setIsBusinessErr(Boolean isBusinessErr) {
		this.isBusinessErr = isBusinessErr;
	}
}
