/**
 * 
 */
package com.xunlei.netty.soaserver.component;

import java.lang.reflect.Type;

import com.google.gson.Gson;

/**
 * 数据传输基类
 * 
 * @author wangcanyi
 *
 */
public class DTOBase {
	private String objStr;
	private String objType;
	private String[] objGenericType;

	/**
	 * @return 对象JSON字符串
	 */
	public String getObjStr() {
		return objStr;
	}

	/**
	 * @param objStr 对象JSON字符串
	 */
	public void setObjStr(String objStr) {
		this.objStr = objStr;
	}

	/**
	 * @return 对象类型
	 */
	public String getObjType() {
		return objType;
	}

	/**
	 * @param objType 对象类型
	 */
	public void setObjType(String objType) {
		this.objType = objType;
	}

	/**
	 * @return 对象泛型类型
	 */
	public String[] getObjGenericType() {
		return objGenericType;
	}

	/**
	 * @param objGenericType 对象泛型类型
	 */
	public void setObjGenericType(String[] objGenericType) {
		this.objGenericType = objGenericType;
	}

	/**
	 * 无参数构造
	 */
	public DTOBase() {

	}

	/**
	 * 参数构造
	 * 
	 * @param object
	 */
	public DTOBase(Object object) {
		if (object != null) {
			Gson gson = new Gson();
			this.objStr = gson.toJson(object);
			this.objType = object.getClass().getName();
			this.objGenericType = GenericBase.getGenericTypeStringByObject(object);
		}
	}

	/**
	 * 参数构造
	 * 
	 * @param object
	 * @param objType 对象类型，当对象为空且需知道类型时使用
	 */
	public DTOBase(Object object, Class<?> objType) {
		this(object);
		if (objType != null)
			this.objType = objType.getName();
	}

	/**
	 * 返回值是否泛型类型
	 * 
	 * @return
	 */
	public boolean isObjGenericType() {
		if (this.objGenericType != null && this.objGenericType.length > 0)
			return true;
		return false;
	}

	/**
	 * 获取对象类型
	 * 
	 * @return
	 * @throws Exception
	 */
	public Class<?> getObjectClass() throws Exception {
		return Class.forName(this.objType);
	}

	/**
	 * 获取对象
	 * 
	 * @return
	 * @throws Exception
	 */
	public Object getObject() throws Exception {
		Object obj = null;
		Gson gson = new Gson();
		Class<?> ObjClass = this.getObjectClass();
		if (this.isObjGenericType()) {// 是否泛型
			Type parameterizedType = GenericBase.getType(ObjClass, this.getObjGenericType());
			obj = gson.fromJson(this.objStr, parameterizedType);
		} else {
			obj = gson.fromJson(this.objStr, ObjClass);
		}
		return obj;
	}

}
