/**
 * 
 */
package com.xunlei.netty.soaserver.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import com.google.gson.Gson;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.exception.BusinessRuntimeException;
import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.exception.AbstractHttpServerError;
import com.xunlei.netty.httpserver.exception.ResourceNotFoundError;
import com.xunlei.netty.httpserver.handler.TextResponseHandlerManager;
import com.xunlei.netty.soaserver.cmd.BaseSOACmd;
import com.xunlei.netty.soaserver.cmd.CmdSOAMappers;
import com.xunlei.netty.soaserver.cmd.CmdSOAMeta;
import com.xunlei.netty.soaserver.exception.SOAServerRuntimeException;
import com.xunlei.netty.util.IPGetterHelper;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NettyServerConfig;

/**
 * 命令映射分发
 * 
 * @author wangcanyi
 *
 */
@Service
public class CmdSOAMapperDispatcher extends BaseSOAPageDispatcher {
	private static final Logger log = Log.getLogger();

	@Autowired
	private TextResponseHandlerManager handlerManager;
	@Autowired
	private CmdSOAMappers cmdSOAMappers;
	@Autowired
	private NettyServerConfig serverConfig;

	/**
	 * 命令映射分发处理
	 * 
	 * @param attach
	 * @return
	 * @throws Exception
	 */
	private RpcInput _dispatch(RpcOutput rpcOutput) throws Exception {
		RpcInput rpcInput = rpcOutput.getRpcInput();
		Transaction t = Cat.newTransaction("PigeonService", rpcOutput.getSimpleName());
		t.addData("clientIp", rpcOutput.getIpAddress());
		MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
		// 设置cross信息
		Cat.logEvent("PigeonService.client", rpcOutput.getIpAddress());
		Cat.logEvent("PigeonService.app", rpcOutput.getAppName());
		// 设置logview信息
		tree.setRootMessageId(rpcOutput.getRootMessageId());
		tree.setParentMessageId(rpcOutput.getMessageId());
		tree.setMessageId(rpcOutput.getChildMessageId());
		try {
			CmdSOAMeta soaMeta = cmdSOAMappers.getCmdSOAMeta(rpcOutput.getName());
			if (soaMeta == null)
				throw new SOAServerRuntimeException("资源未找到：" + rpcOutput.getInterfaceName() + "." + rpcOutput.getMethodName());
			BaseSOACmd cmd = soaMeta.getCmd();
			Method method = soaMeta.getMethod();
			Object[] args = soaMeta.getMethodArgs(rpcOutput.getMethodObjectArgs(serverConfig.getServerSignKey()));// 获取参数，做兼容
			Object resultObj = method.invoke(cmd, args);
			rpcInput.setRetObj(resultObj);
			t.setStatus(Transaction.SUCCESS);
		} catch (IllegalAccessException e) {
			Exception ex = (Exception) e.getCause();
			if (ex != null) {
				rpcInput.setException(ex);
				if (ex instanceof BusinessRuntimeException) {
					log.warn("命令映射分发处理[BusinessRuntimeException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), ex);
					t.setStatus(Transaction.SUCCESS);
				} else {
					log.error("命令映射分发处理[" + ex.getClass().getSimpleName() + "] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), ex);
					t.setStatus(ex);
				}
			} else {
				rpcInput.setException(e);
				t.setStatus(e);
				log.error("命令映射分发处理[IllegalAccessException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), e);
			}
		} catch (IllegalArgumentException e) {
			Exception ex = (Exception) e.getCause();
			if (ex != null) {
				rpcInput.setException(ex);
				if (ex instanceof BusinessRuntimeException) {
					log.warn("命令映射分发处理[BusinessRuntimeException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), ex);
					t.setStatus(Transaction.SUCCESS);
				} else {
					log.error("命令映射分发处理[" + ex.getClass().getSimpleName() + "] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), ex);
					t.setStatus(ex);
				}
			} else {
				rpcInput.setException(e);
				t.setStatus(e);
				log.error("命令映射分发处理[IllegalArgumentException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), e);
			}
		} catch (InvocationTargetException e) {
			Exception ex = (Exception) e.getCause();
			if (ex != null) {
				rpcInput.setException(ex);
				if (ex instanceof BusinessRuntimeException) {
					log.warn("命令映射分发处理[BusinessRuntimeException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), ex);
					t.setStatus(Transaction.SUCCESS);
				} else {
					log.error("命令映射分发处理[" + ex.getClass().getSimpleName() + "] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), ex);
					t.setStatus(ex);
				}
			} else {
				rpcInput.setException(e);
				t.setStatus(e);
				log.error("命令映射分发处理[InvocationTargetException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), e);
			}
		} catch (SOAServerRuntimeException e) {
			rpcInput.setException(e);
			log.error("命令映射分发处理[SOAServerRuntimeException] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), e);
			t.setStatus(e);
		} catch (Exception e) {
			rpcInput.setException(e);
			log.error("命令映射分发处理[Exception] Name:" + rpcOutput.getName() + " args:" + rpcOutput.getMethodArgs(), e);
			t.setStatus(e);
		} finally {
			t.complete();
		}
		return rpcInput;
	}

	@Override
	protected RpcInput dispatch(RpcOutput rpcOutput) throws Exception {
		Gson gson = new Gson();
		log.debug("Netty服务.SOA请求.rpcOutput:" + gson.toJson(rpcOutput));
		RpcInput rpcInput = _dispatch(rpcOutput);
		log.debug("Netty服务.SOA请求.返回值rpcInput:" + gson.toJson(rpcInput));
		return rpcInput;
	}

	@Override
	public void init() throws Exception {
		log.debug("Netty服务.初始化SOA接口.cmdSOAMappers.initInterfaceMap()");
		cmdSOAMappers.initInterfaceMap();
	}

}
