/**
 * 
 */
package com.xunlei.netty.soaserver.component;

import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.text.DecimalFormat;

import org.apache.commons.lang.StringUtils;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.soaserver.cmd.CmdSOAMappers;
import com.xunlei.netty.soaserver.cmd.CmdSOAMeta;
import com.xunlei.netty.util.HttpUtil;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NetUtil;

/**
 * 抽象管理处理基类
 * 
 * @author wangcanyi
 *
 */
public abstract class BaseSOAPageDispatcher extends SimpleChannelUpstreamHandler {

	private static final Logger log = Log.getLogger();

	/**
	 * 业务处理
	 * 
	 * @param attach
	 * @throws Exception
	 */
	protected abstract RpcInput dispatch(RpcOutput rpcOutput) throws Exception;

	/**
	 * 初始化信息
	 * 
	 * @throws Exception
	 */
	public abstract void init() throws Exception;

	/**
	 * <pre>
	 * 在没有被前面的messageReceived中的catch Throwable的throwableHandlerManager截获掉的情况下,会进放到此方法
	 * 
	 * 也就是这里不处理 业务异常
	 */
	@Override
	public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
		NetUtil.exceptionCaught(ctx, e);
		ctx.getChannel().close();
	}

	@Override
	public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
		Object obj = messageEvent.getMessage();
		try {
			if (obj instanceof String) {
				Gson gson = new Gson();
				RpcOutput rpcOutput = gson.fromJson(obj.toString(), RpcOutput.class);
				if (rpcOutput != null) {
					rpcOutput.setIpAddress(HttpUtil.getIP((InetSocketAddress) ctx.getChannel().getRemoteAddress()));
					RpcInput rpcInput = this.dispatch(rpcOutput);
					//当为非异步方法时，才需写入响应流
					if (rpcInput.getIsAsynMethod().equals(Boolean.toString(false))) {
						String jsonObject = gson.toJson(rpcInput);
						DecimalFormat df = new DecimalFormat("0000000000");
						String lengthStr = df.format(jsonObject.getBytes().length);// 长度固定10位
						log.debug("Netty框架.SOA.发送响应[BaseSOAPageDispatcher.messageReceived],length:" + lengthStr + ";Data:" + jsonObject);
						ChannelFuture f = messageEvent.getChannel().write(lengthStr + jsonObject);
						f.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
					}
				}
			} else {
				throw new RuntimeException("cant resolve message:" + obj);
			}
		} finally {
			ctx.sendUpstream(messageEvent);// 确保所有handler都流过
		}
	}
}
