/**
 * 
 */
package com.xunlei.netty.soaserver.cmd.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xunlei.netty.soaserver.cmd.BaseSOACmd;
import com.xunlei.netty.soaserver.cmd.CmdSOAMappers;
import com.xunlei.netty.soaserver.cmd.CmdSOAMeta;
import com.xunlei.netty.soaserver.cmd.common.args.SOACmdArg;
import com.xunlei.netty.soaserver.component.DTOBase;
import com.xunlei.netty.soaserver.component.RpcOutput;
import com.xunlei.netty.util.spring.BeanUtil;

/**
 * @author wangcanyi
 *
 */
@Service
public class SOACmdServiceCmd extends BaseSOACmd implements ISOACmdService {
	@Autowired
	private CmdSOAMappers cmdSOAMappers;

	@Override
	public List<RpcOutput> findSOACmd(SOACmdArg arg) throws Exception {
		List<RpcOutput> result = new ArrayList<RpcOutput>();
		if (arg != null) {
			Map<String, CmdSOAMeta> allMeta = cmdSOAMappers.getCmdAllMap();
			if (allMeta != null && allMeta.size() > 0) {
				for (Entry<String, CmdSOAMeta> metaMap : allMeta.entrySet()) {
					CmdSOAMeta meta = metaMap.getValue();
					// 搜索条件
					if (StringUtils.isNotBlank(arg.getInterfaceName())) {
						if (!meta.getRpcObjectBase().getInterfaceName().equals(arg.getInterfaceName()))
							continue;
					}
					if (arg.getIsAsynMethod() != null) {
						if (!meta.getRpcObjectBase().getIsAsynMethod().equals(arg.getIsAsynMethod().toString()))
							continue;
					}
					if (arg.getIsAdmin() != null) {
						if (meta.getRpcObjectBase().isAdmin() != arg.getIsAdmin().booleanValue())
							continue;
					}
					// 赋值
					RpcOutput rpcOutput = this.getRpcOutput(meta);
					result.add(rpcOutput);
				}
			}
		}
		return result;
	}

	@Override
	public RpcOutput getSOACmd(String name) throws Exception {
		RpcOutput result = null;
		if (StringUtils.isNotBlank(name)) {
			Map<String, CmdSOAMeta> allMeta = cmdSOAMappers.getCmdAllMap();
			if (allMeta != null && allMeta.size() > 0) {
				for (Entry<String, CmdSOAMeta> metaMap : allMeta.entrySet()) {
					String metaName = metaMap.getKey();
					CmdSOAMeta meta = metaMap.getValue();
					if (metaName.equals(name)) {
						result = this.getRpcOutput(meta);
						break;
					}

				}
			}
		}
		return result;
	}

	/**
	 * 获取Rpc 对象输出
	 * 
	 * @param meta CmdSOA元数据
	 * @return
	 */
	private RpcOutput getRpcOutput(CmdSOAMeta meta) {
		RpcOutput result = null;
		if (meta != null) {
			result = new RpcOutput();
			BeanUtil.copyProperties(result, meta.getRpcObjectBase());
			Class<?>[] argTypes = meta.getMethod().getParameterTypes();
			if (argTypes != null && argTypes.length > 0) {
				DTOBase[] argDTO = new DTOBase[argTypes.length];
				for (int i = 0; i < argTypes.length; i++) {
					Class<?> argType = argTypes[i];
					argDTO[i] = new DTOBase(null, argType);
				}
				result.setMethodArgs(argDTO);
			}
		}
		return result;
	}
}
