/**
 * 
 */
package com.xunlei.netty.soaserver.cmd;

import java.lang.reflect.Method;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;

import com.xunlei.netty.soaserver.component.RpcObjectBase;

/**
 * CMD SOA接口原数据
 * 
 * @author wangcanyi
 *
 */
public class CmdSOAMeta {
	private BaseSOACmd cmd;
	private Method method;
	private RpcObjectBase rpcObjectBase;

	/**
	 * 构造器
	 * 
	 * @param cmd 服务实现类
	 * @param method 方法名
	 * @param interfaceName 接口名
	 */
	public CmdSOAMeta(BaseSOACmd cmd, Method method, Class<?> interfaceClass) {
		this.cmd = cmd;
		this.method = method;
		this.rpcObjectBase = new RpcObjectBase();
		this.rpcObjectBase.setRpcObject(interfaceClass, method);
	}

	@Override
	public String toString() {
		return this.rpcObjectBase.getName();
	}

	/**
	 * @return SOA服务 实现类
	 */
	public BaseSOACmd getCmd() {
		return cmd;
	}

	/**
	 * @param cmd SOA服务 实现类
	 */
	public void setCmd(BaseSOACmd cmd) {
		this.cmd = cmd;
	}

	/**
	 * @return 接口方法
	 */
	public Method getMethod() {
		return method;
	}

	/**
	 * @param method 接口方法
	 */
	public void setMethod(Method method) {
		this.method = method;
	}

	/**
	 * @return RPC对象基类
	 */
	public RpcObjectBase getRpcObjectBase() {
		return rpcObjectBase;
	}

	/**
	 * @param rpcObjectBase RPC对象基类
	 */
	public void setRpcObjectBase(RpcObjectBase rpcObjectBase) {
		this.rpcObjectBase = rpcObjectBase;
	}

	/**
	 * 获取方法运行参数（兼容）
	 * 
	 * @param args
	 * @return
	 * @throws Exception
	 */
	public Object[] getMethodArgs(Object[] args) throws Exception {
		// 传入参数长度
		int argsLength = 0;
		if (args != null)
			argsLength = args.length;
		// 方法参数长度
		int typeLength = 0;
		Class<?>[] argsType = this.method.getParameterTypes();
		if (argsType != null)
			typeLength = argsType.length;
		// 当传入参数长度小于方法参数长度时，需要补齐参数，做兼容
		if (argsLength < typeLength) {
			for (int i = argsLength; i < typeLength; i++) {
				Class<?> type = argsType[i];
				args = ArrayUtils.add(args, this.getTypeDefaultValue(type));
			}
		}
		return args;
	}

	/**
	 * 获取类型默认值
	 * 
	 * @param type
	 * @return
	 */
	private Object getTypeDefaultValue(Class<?> type) {
		Object obj = null;
		if (type != null && type.isPrimitive()) {// 基本数据类型
			if (type == byte.class)
				return 0;
			if (type == short.class)
				return 0;
			if (type == int.class)
				return 0;
			if (type == long.class)
				return 0L;
			if (type == float.class)
				return 0.0f;
			if (type == double.class)
				return 0.0d;
			if (type == char.class)
				return '\u0000';
			if (type == boolean.class)
				return false;
		}
		return obj;
	}
}
