/**
 * 
 */
package com.xunlei.netty.soaserver;

import static org.jboss.netty.channel.Channels.pipeline;

import java.util.NoSuchElementException;

import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.handler.codec.frame.LineBasedFrameDecoder;
import org.jboss.netty.handler.codec.string.StringDecoder;
import org.jboss.netty.handler.codec.string.StringEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xunlei.netty.BootstrapFactory;
import com.xunlei.netty.httpserver.component.NOPDispatcher;
import com.xunlei.netty.soaserver.component.BaseSOAPageDispatcher;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.spring.AfterConfig;

/**
 * SOA服务管道工厂
 * 
 * @author wangcanyi
 *
 */
@Component
public class SOAServerPipelineFactory implements ChannelPipelineFactory {
	private static final Logger log = Log.getLogger();
	/**
	 * 配置信息
	 */
	@Autowired
	private NettyServerConfig config;
	/**
	 * 服务启动程序
	 */
	@Autowired
	private BootstrapFactory bootstrap;
	/**
	 * 业务线程池
	 */
	private ExecutionHandler executionHandler;
	/**
	 * 不处理业务请求
	 */
	@Autowired
	private NOPDispatcher nopDispatcher;
	/**
     * 
     */
	@Autowired
	private BaseSOAPageDispatcher pageDispatcher;

	/**
	 * 字符串编码
	 */
	private StringEncoder encoder = new StringEncoder();

	/**
	 * 初始化
	 */
	@AfterConfig
	public void init() {
		executionHandler = new ExecutionHandler(config.getPipelineExecutor());
	}

	@Override
	public ChannelPipeline getPipeline() throws Exception {
		ChannelPipeline pipeline = pipeline();
		log.debug("Netty服务.SOA请求.管道初始化.getPipeline()");
		if (bootstrap.isStop()) {
			pipeline.addLast("nop", nopDispatcher);// TODO:正在关闭了,现直接简单处理内部什么逻辑都不走
			return pipeline;
		}
		pipeline.addLast("framedecoder",new LineBasedFrameDecoder(Integer.MAX_VALUE));//以换行符来决定数据是否结束（TPC 分包）
		pipeline.addLast("decoder", new StringDecoder());
		pipeline.addLast("encoder", encoder);
		pipeline.addLast("pageDispatcher", pageDispatcher);
		// A. 让NioWorker来负责解码工作
		// B. 解码工作也让ExecutionHandler中的线程池来处理
		String addBefore = config.getPlAddBefore();
		if (addBefore != null) {
			if (addBefore.isEmpty()) {
				pipeline.addFirst("executor", executionHandler); // TODO: 2012-05-31 这里严重注意，因为现在线程池改成了不考虑事件顺序，所以不要把线程池放到
																	// decoder及aggeator前（decoder及aggeator是对事件敏感的）
			} else {
				try {
					pipeline.addBefore(addBefore, "executor", executionHandler);
				} catch (NoSuchElementException e) {// 参数配置错误
					log.error("config error,config.plAddBefore:{} NOT FOUND,execption:{}", addBefore, e);
					pipeline.addFirst("executor", executionHandler);
				}
			}
		}
		return pipeline;
	}
	/**
     * 重建pipeline顺序
     */
    public SOAServerPipelineFactory rebuildPipeline() {
        return this;
    }
}
