/**
 * 
 */
package com.xunlei.netty.httpserver.util;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.apache.commons.lang.StringUtils;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Trace;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;

/**
 * Cat logback日志 自定义Appender
 * 
 * @author wangcanyi
 *
 */
public class CatLogbackAppender extends AppenderBase<LoggingEvent> {

	@Override
	protected void append(LoggingEvent eventObject) {
		boolean isTraceMode = Cat.getManager().isTraceMode();
		Level level = eventObject.getLevel();
		if (level.isGreaterOrEqual(Level.ERROR)) {
			logError(eventObject);
		} else if (isTraceMode) {
			logTrace(eventObject);
		}
	}

	/**
	 * 记录错误日志
	 * 
	 * @param event
	 */
	private void logError(LoggingEvent event) {
		IThrowableProxy throwableProxy = event.getThrowableProxy();
		if (throwableProxy != null) {
			if (throwableProxy instanceof ThrowableProxy) {
				ThrowableProxy tp = (ThrowableProxy) throwableProxy;
				String message = event.getMessage() + tp.getMessage();
				if (StringUtils.isNotBlank(message)) {
					Cat.logError(message, tp.getThrowable());
				} else {
					Cat.logError(tp.getThrowable());
				}
			}
		}
	}

	/**
	 * 记录跟踪
	 * 
	 * @param event
	 */
	private void logTrace(LoggingEvent event) {
		String type = "Logback";
		String name = event.getLevel().toString();
		String data = event.getMessage();

		IThrowableProxy throwableProxy = event.getThrowableProxy();

		if (throwableProxy != null && throwableProxy instanceof ThrowableProxy) {
			ThrowableProxy tp = (ThrowableProxy) throwableProxy;
			data = data + '\n' + buildExceptionStack(tp.getThrowable());
		}
		Cat.logTrace(type, name, Trace.SUCCESS, data);
	}

	/**
	 * 生成异常堆栈信息
	 * 
	 * @param exception
	 * @return
	 */
	private String buildExceptionStack(Throwable exception) {
		if (exception != null) {
			StringWriter writer = new StringWriter(2048);

			exception.printStackTrace(new PrintWriter(writer));
			return writer.toString();
		} else {
			return "";
		}
	}
}
