package com.xunlei.netty.httpserver.component;

import java.util.Arrays;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMessageDecoder;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;

import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.Log;

/**
 * <pre>
 * 1.增加流量统计
 * 2.增加开始解码时间
 * </pre>
 * 
 * @author ZengDong
 * @since 2010-3-25 下午02:30:03
 */
public class XLHttpRequestDecoder extends HttpMessageDecoder {

    private static final String[] httpMethods = {
        "GET",
        "POST",
        "HEAD",
        "PUT",
        "TRACE",
        "CONNECT",
        "OPTIONS",
        "DELETE"
    };
    private static final int tryLen = 8;

    public static void main(String[] args) {
        ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
        cb.writeBytes("123456GET / HTTP/1.1".getBytes());
        skipNonHttpMethodCharacters(cb);
    }

    /**
     * 尝试在解析httpRequest第一行时,把多余的字符串去除
     */
    public static void skipNonHttpMethodCharacters(ChannelBuffer buffer) {
        int idx = buffer.readerIndex();
        while (true) {
            byte[] methodTry = new byte[tryLen];
            buffer.readBytes(methodTry);
            String methodTryStr = new String(methodTry).toUpperCase();

            for (String str : httpMethods) {
                if (Character.isWhitespace((char) methodTry[str.length()]) && methodTryStr.startsWith(str)) {
                    int len = buffer.readerIndex() - tryLen - idx;
                    if (len > 0) {
                        byte[] bytes = new byte[len];
                        buffer.readerIndex(idx);

                        buffer.readBytes(bytes);
                        String skipString = new String(bytes);
                        log.warn("{}", skipString);
                    } else {
                        buffer.readerIndex(buffer.readerIndex() - tryLen);
                    }
                    return;
                }
            }
            buffer.readerIndex(buffer.readerIndex() + 1 - tryLen);
        }
    }

    private static final Logger log = Log.getLogger();

    public XLHttpRequestDecoder(NettyServerConfig config) {
        super(4096, 65536, 65536);
    }

    @Override
    protected boolean isDecodingRequest() {
        return true;
    }

    @Override
    protected HttpMessage createMessage(String[] initialLine) throws Exception {
        HttpMethod httpMethod = HttpMethod.valueOf(initialLine[0]);
        try {
            return new XLHttpRequest(HttpVersion.valueOf(initialLine[2]), httpMethod, initialLine[1]);
        } catch (Exception e) {// httpClient经常发送的http请求不严格,造成解析失败,这时这里记录下日志,并放宽限制,尽量解析成功
            String fix = initialLine[1] + " " + initialLine[2];// 这里尝试找回uri
            int result = 0;
            for (result = fix.length(); result > 0; --result) {
                if (Character.isWhitespace(fix.charAt(result - 1))) {
                    break;
                }
            }
            String version = fix.substring(result);
            for (; result > 0; --result) {
                if (!Character.isWhitespace(fix.charAt(result - 1))) {
                    break;
                }
            }
            String uri = fix.substring(0, result);
            // uri = uri.replaceAll("\t", "%09").replaceAll("\n", "%0D").replaceAll("\r", "%0A").replaceAll(" ", "+");
//            log.error("parse httpRequest initialLine fail!\n\tori:{}\n\t      fix:{}\n\t      uri:{}\n\t  version:{}\n\t{}", new Object[] {
//                Arrays.toString(initialLine),
//                fix,
//                uri,
//                version,
//                e.getMessage()
//            });
			String errorMsg = String.format("parse httpRequest initialLine fail!\n\tori:{%s}\n\t      fix:{%s}\n\t      uri:{%s}\n\t  version:{%s}\n\t{%s}",
					Arrays.toString(initialLine), fix, uri, version, e.getMessage());
			log.error(errorMsg, e);
            return new XLHttpRequest(HttpVersion.valueOf(version), httpMethod, uri);// TODO:这里有没有更好的解决办法
        }
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        // 一个请求会 调用多次
        super.messageReceived(ctx, e);
    }
}
