package com.xunlei.netty.httpserver.cmd.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.dianping.cat.Cat;
import com.xunlei.netty.cache.JRedisProxy;
import com.xunlei.netty.httpserver.cmd.BaseStatCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.cmd.annotation.CmdAdmin;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.component.XLHttpResponse.ContentType;
import com.xunlei.netty.soaserver.component.SOAServiceBase;
import com.xunlei.netty.soaserver.component.SOAServiceCmdFactory;
import com.xunlei.netty.util.HtmlUtil;
import com.xunlei.netty.util.HttpUtil;
import com.xunlei.netty.util.IPAuthenticator;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.spring.Config;
import com.xunlei.netty.util.spring.ConfigBeanPostProcessor;

/**
 * SOA 服务相关
 * 
 * @author wangcanyi
 *
 */
@Service
public class SOAServerCmd extends BaseStatCmd {
	private static final Logger log = Log.getLogger();
	@Autowired
	private ConfigBeanPostProcessor configProcessor;

	/**
	 * SOA 服务API 列表
	 */
	@CmdAdmin
	public Object soaServiceAPIList(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		response.setInnerContentType(ContentType.html);
		List<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
		String tmp = "";
		Map<String, String> mapData = new LinkedHashMap<String, String>();
		// SOA API 服务列表
		List<SOAServiceCmdFactory> soaAPIList = SOAServiceCmdFactory.getSoaServiceCmdFactoryList();
		if (soaAPIList != null && soaAPIList.size() > 0) {
			for (SOAServiceCmdFactory soaServiceCmdFactory : soaAPIList) {
				Class<?> serviceBaseClass = soaServiceCmdFactory.getClass();
				while (serviceBaseClass != null && serviceBaseClass != SOAServiceBase.class) {
					serviceBaseClass = serviceBaseClass.getSuperclass();
				}
		        if(serviceBaseClass != null){
		        	Field[] fieldArray = serviceBaseClass.getDeclaredFields();
					if(fieldArray != null && fieldArray.length > 0){
						for (Field field : fieldArray) {
							if(field.getName().equals("log") || field.getName().equals("appName"))
								continue;
							field.setAccessible(true);
							mapData = new LinkedHashMap<String, String>();
							mapData.put("ConfigKey", String.format("%s服务[%s]", soaServiceCmdFactory.getAppName(),field.getName()));
							String appName = HtmlUtil.getInputHidden("appName", soaServiceCmdFactory.getAppName());
							String fieldName = HtmlUtil.getInputHidden("fieldName", field.getName());
							String fieldValue = HtmlUtil.getInputText("fieldValue", field.get(soaServiceCmdFactory) + "");
							String configValueText = HtmlUtil.getHtmlForm(appName + fieldName + fieldValue, "/sOAServer/updateSOAServiceAPI");
							mapData.put("ConfigValue", configValueText);
							tableData.add(mapData);
						}
					}
		        }
			}
		}
		if(tableData.size() == 0){//若无数据时，需展示空列表
			mapData = new LinkedHashMap<String, String>();
			mapData.put("ConfigKey", "当前还未有值");
			mapData.put("ConfigValue", "当前还未有值");
			tableData.add(mapData);
		}
		tmp = HtmlUtil.getHtmlTable(tableData);
		return tmp;
	}
	
	/**
	 * 临时修改SOA 服务API信息
	 */
	@CmdAdmin
	public Object updateSOAServiceAPI(XLHttpRequest request, XLHttpResponse response) throws Exception {
		init(request, response);
		StringBuilder tmp = new StringBuilder("update SOA Service API...\n");
		String appName = request.getParameter("appName", "");
		String fieldName = request.getParameter("fieldName", "");
		String fieldValue = request.getParameter("fieldValue", "");
		if(StringUtils.isBlank(appName))
			throw new Exception("appName为空");
		if(StringUtils.isBlank(fieldName))
			throw new Exception("fieldName为空");
		List<SOAServiceCmdFactory> soaAPIList = SOAServiceCmdFactory.getSoaServiceCmdFactoryList();
		if (soaAPIList != null && soaAPIList.size() > 0) {
			SOAServiceCmdFactory soaAPIService = null;
			for (SOAServiceCmdFactory soaServiceCmdFactory : soaAPIList) {//查找到API 服务
				if(appName.equals(soaServiceCmdFactory.getAppName())){
					soaAPIService = soaServiceCmdFactory;
					break;
				}
			}
			if(soaAPIService != null){
				Class<?> serviceBaseClass = soaAPIService.getClass();
				while (serviceBaseClass != null && serviceBaseClass != SOAServiceBase.class) {//查找基类
					serviceBaseClass = serviceBaseClass.getSuperclass();
				}
				if(serviceBaseClass != null){
					Field field = serviceBaseClass.getDeclaredField(fieldName);
					if(field != null){
						field.setAccessible(true);
						String oriValue = field.get(soaAPIService) + "";
						SimpleTypeConverter typeConverter = new SimpleTypeConverter();// 创建简单类型转换器
						Object value = typeConverter.convertIfNecessary(fieldValue, field.getType());
						field.set(soaAPIService,value);
						//记录修改日志
						configProcessor.appendResetHistory("SOAServiceAPI."+appName, fieldName, oriValue, fieldValue);
					}
				}
			}
		}
		String refererUrl = request.getHeader("Referer");// 获取发起请求地址的Url
		if (StringUtils.isNotBlank(refererUrl))
			response.redirect(refererUrl);
		return tmp.toString();
	}
}
