package com.xunlei.netty.httpserver.cmd;

import java.lang.reflect.Field;

import org.apache.commons.lang.StringUtils;

import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.HTTPServerRuntimeException;

/**
 * @author ZengDong
 * @since 2010-3-18 下午01:44:53
 */
public abstract class BaseCmd {

	/**
	 * 当前命令默认调用方法，有需要请覆盖
	 *
	 * @param request
	 * @param response
	 * @return Object 处理结果,则调用者(CmdDispatcher)对此结果作进一步封装处理,一般是当作response的内容
	 * @throws Exception 抛出异常给调用者(CmdDispatcher)
	 **/
	public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
		return null;
	}

	/**
	 * 接口方法执行前，预先执行此方法
	 * 
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void processBegin(XLHttpRequest request, XLHttpResponse response) throws Exception {

	}

	/**
	 * 接口方法执行后，执行此方法
	 * 
	 * @param request
	 * @param response
	 * @param resultObj 接口方法执行的返回值
	 * @throws Exception
	 */
	public void processEnd(XLHttpRequest request, XLHttpResponse response, Object resultObj) throws Exception {

	}

	/**
	 * HTTP请求参数转化为Object
	 * 
	 * @param classType
	 * @param request
	 * @return
	 * @throws Exception
	 */
	protected <T> T getObjectByXLHttpRequest(Class<T> classType, XLHttpRequest request) throws Exception {
		T resultObject = null;
		if (classType == null)
			new HTTPServerRuntimeException("classType为空");
		if (request == null)
			new HTTPServerRuntimeException("request为空");
		resultObject = classType.newInstance();
		Field[] fieldArray = classType.getDeclaredFields();
		if (fieldArray != null && fieldArray.length > 0) {
			for (Field field : fieldArray) {
				field.setAccessible(true);
				String key = field.getName();
				String value = request.getParameter(key, "");
				if (StringUtils.isNotBlank(value))
					this.setObjectField(field, resultObject, value);
			}
		}
		return resultObject;
	}

	/**
	 * 设置对象字段值
	 * 
	 * @param field
	 * @param resultObject
	 * @param value
	 * @throws Exception
	 */
	private void setObjectField(Field field, Object resultObject, String value) throws Exception {
		Class<?> type = field.getType();
		if (type.isPrimitive()) {// 基本数据类型
			if (type == byte.class)
				field.setByte(resultObject, Byte.parseByte(value));
			if (type == short.class)
				field.setShort(resultObject, Short.parseShort(value));
			if (type == int.class)
				field.setInt(resultObject, Integer.parseInt(value));
			if (type == long.class)
				field.setLong(resultObject, Long.parseLong(value));
			if (type == float.class)
				field.setFloat(resultObject, Float.parseFloat(value));
			if (type == double.class)
				field.setDouble(resultObject, Double.parseDouble(value));
			if (type == char.class)
				field.setChar(resultObject, value.charAt(0));
			if (type == boolean.class)
				field.setBoolean(resultObject, Boolean.parseBoolean(value));
		} else {
			field.set(resultObject, value);
		}
	}
}
