/**
 * 
 */
package com.xunlei.netty.grpcserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

import io.grpc.BindableService;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.netty.NettyServerBuilder;

import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xunlei.netty.grpcserver.interceptor.CatServerInterceptor;
import com.xunlei.netty.soaserver.cmd.BaseSOACmd;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NetUtil;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.spring.BeanUtil;
import com.xunlei.netty.util.spring.SpringBootstrap;

/**
 * GRPC 服务工厂
 * 
 * @author wangcanyi
 *
 */
@Component
public class GRPCServerFactory {
	private static final Logger log = Log.getLogger();
	/**
	 * 配置信息
	 */
	@Autowired
	private NettyServerConfig config;
	/**
	 * GRPC服务
	 */
	private io.grpc.Server grpcServer;

	public void start() throws Exception {
		if (config.getListen_grpc_port() <= 0)
			throw new Exception("GRPC 服务启动端口必须大于0");
		NetUtil.checkSocketPortBind(config.getListen_grpc_port());// 校验端口是否被占用
		List<BindableService> bsList = this.getBindableServiceList();
		if (bsList == null || bsList.size() == 0)
			throw new Exception("GRPC 服务启动 未找到服务实现类");
		ServerBuilder<?> serverBuilder = ServerBuilder.forPort(config.getListen_grpc_port());
//		Executor executor = config.getPipelineExecutor();
//		serverBuilder = serverBuilder.executor(executor);
		for (BindableService bindableService : bsList) {
			serverBuilder.addService(ServerInterceptors.intercept(bindableService, new CatServerInterceptor()));
		}
		grpcServer = serverBuilder.build();
		grpcServer.start();
		//grpcServer.awaitTermination();
	}

	/**
	 * 获取GRPC服务实现类
	 * 
	 * @return
	 */
	private List<BindableService> getBindableServiceList() {
		List<BindableService> bsList = new ArrayList<BindableService>();
		for (String name : SpringBootstrap.getContext().getBeanDefinitionNames()) {
			Object obj = BeanUtil.getTypedBean(name);
			if (obj instanceof BindableService) {
				bsList.add((BindableService) obj);
			}
		}
		return bsList;
	}
}
