/**
 * 
 */
package com.xunlei.netty.exception;

import com.xunlei.netty.soaserver.component.DTOBase;

/**
 * 业务异常
 * 
 * @author wangcanyi
 *
 */
public class BaseRuntimeException extends RuntimeException {
	private static final long serialVersionUID = 1L;
	private String errorCode;

	public BaseRuntimeException(String errorMsg) {
		super(errorMsg);
	}

	public BaseRuntimeException(Exception e) {
		super(e);
	}

	public BaseRuntimeException(String errorCode, String errorMsg) {
		super(errorMsg);
		this.errorCode = errorCode;
	}

	public BaseRuntimeException(String errorCode, String errorMsg, Exception e) {
		super(errorMsg, e);
		this.errorCode = errorCode;
	}

	public BaseRuntimeException(String errorCode, Exception e) {
		super(e);
		this.errorCode = errorCode;
	}

	public String getErrorCode() {
		return this.errorCode;
	}
}
