/**
 * 
 */
package com.xunlei.netty.consul.loadbalance;

import java.util.List;

import com.ecwid.consul.v1.catalog.model.CatalogService;
import com.ecwid.consul.v1.health.model.HealthService;

/**
 * 负载均衡接口
 * 
 * @author wangcanyi
 *
 */
public interface ILoadBalance {
	/**
	 * 选择一个服务
	 * 
	 * @param serviceName 服务名
	 * @param serviceList 服务列表
	 * @return
	 */
	HealthService chooseByList(String serviceName, List<HealthService> serviceList);

	/**
	 * 选择一个服务
	 * 
	 * @param serviceName 服务名
	 * @return
	 */
	HealthService choose(String serviceName);
}
