/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util.spring;

import com.xunlei.netty.util.ArraysUtil;
import com.xunlei.netty.util.DateStringUtil;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.ReflectConvention;
import com.xunlei.netty.util.StringTools;
import com.xunlei.netty.util.spring.AfterBootstrap;
import com.xunlei.netty.util.spring.AfterConfig;
import com.xunlei.netty.util.spring.BeanUtil;
import com.xunlei.netty.util.spring.Config;
import com.xunlei.netty.util.spring.ServerConfigError;
import com.xunlei.spring.ExtendedPropertyPlaceholderConfigurer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

@Component
public class ConfigBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    private static Logger log = Log.getLogger();
    public static final String RESET_HISTORY_FMT = "%-20s %40s.%-40s %-20s %-20s\n";
    private Map<Method, Object> afterConfigCache = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, ConfigEntry> configCache = Collections.synchronizedMap(new LinkedHashMap());
    @Autowired
    private ExtendedPropertyPlaceholderConfigurer serverPropertyConfigurer;
    private StringBuilder resetHistory = new StringBuilder(String.format("%-20s %40s.%-40s %-20s %-20s\n", "TIME", "CLASS", "FIELD", "ORIVALUE", "NEWVALUE"));
    private SimpleTypeConverter typeConverter = new SimpleTypeConverter();

    private void cacheConfigUnit(String key, ConfigField configField) {
        ConfigEntry ce = this.configCache.get(key);
        if (ce == null) {
            ce = new ConfigEntry(key);
            this.configCache.put(key, ce);
        }
        ce.addField(configField);
    }

    private String getConfigKey(Field field) {
        Config cfg = field.getAnnotation(Config.class);
        String key = cfg.value().length() <= 0 ? field.getName() : cfg.value();
        return key;
    }

    public StringBuilder getResetHistory() {
        return this.resetHistory;
    }

    public void appendResetHistory(String className, String fieldName, String oriValue, String realValue) {
        String now = DateStringUtil.DEFAULT.now() + "*";
        this.resetHistory.append(String.format(RESET_HISTORY_FMT, now, className, fieldName, oriValue, realValue));
    }

    public void postProcessAfterBootstrap(ApplicationContext context) {
        ArrayList<Object> beans = new ArrayList<Object>(context.getBeanDefinitionCount());
        for (String name : context.getBeanDefinitionNames()) {
            Object bean = context.getBean(name);
            this.postProcessAfterConfig(bean);
            beans.add(bean);
        }
        for (Object e : beans) {
            this.postProcessAfterBootstrap(e);
        }
    }

    private boolean postProcessAfterConfig(final Object bean) throws BeansException {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                AfterConfig cfg = method.getAnnotation(AfterConfig.class);
                AfterBootstrap bst = method.getAnnotation(AfterBootstrap.class);
                if (cfg != null && bst != null) {
                    throw new IllegalStateException("Both @" + AfterConfig.class.getSimpleName() + " and @" + AfterBootstrap.class.getSimpleName() + " is disallowed");
                }
                if (cfg != null) {
                    if (Modifier.isStatic(method.getModifiers()) && !Modifier.isFinal(bean.getClass().getModifiers())) {
                        throw new IllegalStateException("@" + AfterConfig.class.getSimpleName() + " annotation on static methods,it's class must be final");
                    }
                    if (method.getParameterTypes().length != 0) {
                        throw new IllegalAccessError("can't invoke method:" + method.getName() + ",exception:paramters length should be 0");
                    }
                    ReflectionUtils.makeAccessible((Method)method);
                    ReflectionUtils.invokeMethod((Method)method, (Object)bean);
                    log.debug("@{} {}.{}", new Object[]{AfterConfig.class.getSimpleName(), bean.getClass().getSimpleName(), method.getName()});
                    ConfigBeanPostProcessor.this.afterConfigCache.put(method, bean);
                }
            }
        });
        return true;
    }

    private boolean postProcessAfterBootstrap(final Object bean) throws BeansException {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                AfterBootstrap bst = method.getAnnotation(AfterBootstrap.class);
                if (bst != null) {
                    if (Modifier.isStatic(method.getModifiers()) && !Modifier.isFinal(bean.getClass().getModifiers())) {
                        throw new IllegalStateException("@" + AfterBootstrap.class.getSimpleName() + " annotation on static methods,it's class must be final");
                    }
                    if (method.getParameterTypes().length != 0) {
                        throw new IllegalAccessError("can't invoke method:" + method.getName() + ",exception:paramters length should be 0");
                    }
                    ReflectionUtils.makeAccessible((Method)method);
                    ReflectionUtils.invokeMethod((Method)method, (Object)bean);
                    log.debug("@{} {}.{}", new Object[]{AfterBootstrap.class.getSimpleName(), bean.getClass().getSimpleName(), method.getName()});
                }
            }
        });
        return true;
    }

    public boolean postProcessAfterInstantiation(final Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                Config cfg = field.getAnnotation(Config.class);
                if (cfg != null) {
                    if (Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(bean.getClass().getModifiers())) {
                        throw new IllegalStateException("@Config annotation on static fields,it's class must be final");
                    }
                    String key = ConfigBeanPostProcessor.this.getConfigKey(field);
                    ConfigField configField = new ConfigField(bean, field, cfg);
                    ConfigBeanPostProcessor.this.cacheConfigUnit(key, configField);
                    configField.setValue(ConfigBeanPostProcessor.this.serverPropertyConfigurer.getProperty(key), true, false, null);
                }
            }
        });
        return true;
    }

    public StringBuilder printCurrentConfig(StringBuilder sb) {
        ConfigEntry ce;
        sb.append("GUARDED KEY:\n");
        for (Map.Entry<String, ConfigEntry> e : this.configCache.entrySet()) {
            ce = e.getValue();
            if (!ce.guarded) continue;
            sb.append(ce.key).append("\n");
        }
        sb.append("\n");
        sb.append("FIELDS:\n");
        for (Map.Entry<String, ConfigEntry> e : this.configCache.entrySet()) {
            ce = e.getValue();
            for (ConfigField f : ce.configFields) {
                if (!f.resetable) continue;
                sb.append(f).append("\n");
            }
        }
        sb.append("\n");
        for (Map.Entry<String, ConfigEntry> e : this.configCache.entrySet()) {
            ce = e.getValue();
            for (ConfigField f : ce.configFields) {
                if (f.resetable) continue;
                sb.append(f).append("\n");
            }
        }
        sb.append("\n");
        return sb;
    }

    public void reloadConfig() {
        this.reloadConfig(null);
    }

    public void reloadConfig(StringBuilder info) {
        block7: {
            try {
                Properties props = this.serverPropertyConfigurer.reload();
                boolean settted = false;
                for (ConfigEntry configEntry : this.configCache.values()) {
                    String value;
                    if (configEntry.guarded || (value = props.getProperty(configEntry.key)) == null) continue;
                    for (ConfigField configField : configEntry.configFields) {
                        if (!configField.setValue(value, false, false, info)) continue;
                        settted = true;
                    }
                }
                if (!settted) {
                    return;
                }
                if (info != null) {
                    info.append("\nINVOKE METHOD:\n");
                }
                for (Map.Entry entry : this.afterConfigCache.entrySet()) {
                    ReflectionUtils.makeAccessible((Method)((Method)entry.getKey()));
                    ReflectionUtils.invokeMethod((Method)((Method)entry.getKey()), entry.getValue());
                    if (info == null) continue;
                    info.append(entry.getValue().getClass().getSimpleName()).append(".").append(((Method)entry.getKey()).getName()).append("()\n");
                }
            }
            catch (IOException e1) {
                log.error("", (Throwable)e1);
                if (info == null) break block7;
                info.append(e1.getClass().getName()).append(":").append(e1.getMessage()).append("\n");
            }
        }
    }

    public void resetGuradedConfig() {
        this.resetGuradedConfig(null);
    }

    public void resetGuradedConfig(StringBuilder info) {
        for (ConfigEntry ce : this.configCache.values()) {
            if (!ce.guarded) continue;
            ce.guarded = false;
            if (info == null) continue;
            info.append(ce.key).append("\n");
        }
    }

    public void setFieldValue(String key, String value, StringBuilder info) {
        if (key == null) {
            return;
        }
        ConfigEntry ce = this.configCache.get(key);
        if (ce != null) {
            if (StringTools.isEmpty(value)) {
                if (info != null) {
                    info.append("unguard [").append(key).append("]\n");
                }
                if (ce.guarded) {
                    String now = DateStringUtil.DEFAULT.now() + "-";
                    this.resetHistory.append(String.format(RESET_HISTORY_FMT, now, key, "", "", ""));
                    ce.guarded = false;
                }
                return;
            }
            if (info != null) {
                info.append("setting [").append(key).append("] -> [").append(value).append("]\n");
            }
            ce.guarded = true;
            for (ConfigField cf : ce.configFields) {
                cf.setValue(value, false, true, info);
            }
            if (info != null) {
                info.append("\n");
            }
        } else if (info != null) {
            info.append("nofound [").append(key).append("]\n");
        }
    }

    private class ConfigField {
        private Object bean;
        private Config config;
        private Type[] collectionArgsType;
        private Method collectionInserter;
        private Class<?> collectionType;
        private Field field;
        private boolean resetable;
        private Method setter;
        private String split;
        private String splitKeyValue;
        private boolean init;

        public ConfigField(Object bean, Field field, Config config) {
            this.bean = bean;
            this.field = field;
            this.config = config;
            this.resetable = config.resetable();
            this.split = config.split();
            this.splitKeyValue = config.splitKeyValue();
        }

        private void init() {
            if (!this.init) {
                Class<?> type = this.field.getType();
                Type genericType = this.field.getGenericType();
                if (Collection.class.isAssignableFrom(type)) {
                    this.collectionType = this.isFieldTypeAbstract(type) ? (Set.class.isAssignableFrom(type) ? HashSet.class : ArrayList.class) : type;
                    this.checkGenericType(type, genericType, 1);
                    this.setCollectionInserter(false);
                } else if (Map.class.isAssignableFrom(type)) {
                    this.collectionType = this.isFieldTypeAbstract(type) ? HashMap.class : type;
                    this.checkGenericType(type, genericType, 2);
                    this.setCollectionInserter(true);
                } else if (type.isArray()) {
                    this.collectionType = ArrayList.class;
                    this.checkType(type.getComponentType());
                    this.setCollectionInserter(false);
                } else {
                    this.checkType(type);
                }
                try {
                    this.setter = ReflectConvention.buildSetterMethod(this.bean.getClass(), this.field, this.field.getType());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.init = true;
            }
        }

        private void checkGenericType(Class<?> type, Type genericType, int len) {
            if (type == genericType) {
                throw new ServerConfigError("@Config for [" + this.field.getName() + "]'s is a " + type.getSimpleName() + ",it must set genericType");
            }
            ParameterizedTypeImpl pt = (ParameterizedTypeImpl)genericType;
            this.collectionArgsType = pt.getActualTypeArguments();
            for (int i = 0; i < len; ++i) {
                if (!BeanUtil.isNotBasicType(this.collectionArgsType[i])) continue;
                throw new ServerConfigError("@Config for [" + this.field.getName() + "]'s field genericType [" + genericType + "] is not supported.");
            }
        }

        private void checkType(Class<?> type) {
            if (BeanUtil.isNotBasicType(type)) {
                throw new ServerConfigError("@Config for [" + this.field.getName() + "]'s field type [" + this.field.getType().getName() + "] is not supported.");
            }
        }

        private boolean isFieldTypeAbstract(Class<?> type) {
            int mod = type.getModifiers();
            return Modifier.isInterface(mod) || Modifier.isAbstract(mod);
        }

        private void setCollectionInserter(boolean isMap) {
            try {
                this.collectionInserter = isMap ? this.collectionType.getMethod("put", Object.class, Object.class) : this.collectionType.getMethod("add", Object.class);
            }
            catch (Exception e) {
                throw new ServerConfigError("@Config for [" + this.field.getName() + "]'s collectionInserter null!  " + e);
            }
        }

        public boolean setValue(Object value, boolean init, boolean tmp, StringBuilder info) {
            block20: {
                if (value == null) {
                    return false;
                }
                if (info != null) {
                    info.append(String.format("FIELD:%40s.%-40s", this.bean.getClass().getSimpleName(), this.field.getName()));
                }
                if (this.resetable || init) {
                    try {
                        this.init();
                        boolean isArray = this.field.getType().isArray();
                        Object realvalue = null;
                        if (this.collectionType == null) {
                            realvalue = ConfigBeanPostProcessor.this.typeConverter.convertIfNecessary(value, this.field.getType());
                        } else {
                            realvalue = this.collectionType.newInstance();
                            if (Map.class.isAssignableFrom(this.collectionType)) {
                                Class keyType = (Class)this.collectionArgsType[0];
                                Class elementType = (Class)this.collectionArgsType[1];
                                for (String str : StringTools.splitAndTrim(value.toString(), this.split)) {
                                    List<String> pair = StringTools.splitAndTrim(str, this.splitKeyValue);
                                    if (pair.size() == 2) {
                                        Object keyValue = ConfigBeanPostProcessor.this.typeConverter.convertIfNecessary((Object)pair.get(0), keyType);
                                        Object elementValue = ConfigBeanPostProcessor.this.typeConverter.convertIfNecessary((Object)pair.get(1), elementType);
                                        this.collectionInserter.invoke(realvalue, keyValue, elementValue);
                                        continue;
                                    }
                                    log.error("set config:{}.{} MAP FAIL,element[{}] cant find keyvalue by split {}", new Object[]{this.bean.getClass().getSimpleName(), this.field.getName(), str, this.splitKeyValue});
                                }
                            } else {
                                Class elementType = isArray ? this.field.getType().getComponentType() : (Class)this.collectionArgsType[0];
                                for (String str : StringTools.splitAndTrim(value.toString(), this.split)) {
                                    Object elementValue = ConfigBeanPostProcessor.this.typeConverter.convertIfNecessary((Object)str, elementType);
                                    this.collectionInserter.invoke(realvalue, elementValue);
                                }
                            }
                        }
                        ReflectionUtils.makeAccessible((Field)this.field);
                        Object orivalue = ReflectionUtils.getField((Field)this.field, (Object)this.bean);
                        realvalue = isArray ? ConfigBeanPostProcessor.this.typeConverter.convertIfNecessary(realvalue, this.field.getType()) : realvalue;
                        String oriValueToString = ArraysUtil.deepToString(orivalue);
                        String realValueToString = ArraysUtil.deepToString(realvalue);
                        if (info != null) {
                            info.append(String.format("ORIVALUE:%-10s ", oriValueToString));
                        }
                        if (!ArraysUtil.deepEquals(orivalue, realvalue)) {
                            if (null == this.setter) {
                                ReflectionUtils.setField((Field)this.field, (Object)this.bean, (Object)realvalue);
                            } else {
                                ReflectionUtils.invokeMethod((Method)this.setter, (Object)this.bean, (Object[])new Object[]{realvalue});
                            }
                            String now = DateStringUtil.DEFAULT.now();
                            if (tmp) {
                                now = now + "*";
                            }
                            ConfigBeanPostProcessor.this.resetHistory.append(String.format(ConfigBeanPostProcessor.RESET_HISTORY_FMT, now, this.bean.getClass().getSimpleName(), this.field.getName(), oriValueToString, realValueToString));
                            if (info != null) {
                                info.append("NEWVALUE:").append(realValueToString).append("\n");
                            }
                            return true;
                        }
                        if (info != null) {
                            info.append("NO CHANGE\n");
                        }
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                        if (info == null) break block20;
                        info.append(e.getClass().getName()).append(":").append(e.getMessage()).append("\n");
                    }
                }
            }
            if (!this.resetable && info != null) {
                info.append("NO RESETABLE\n");
            }
            return false;
        }

        public String toString() {
            ReflectionUtils.makeAccessible((Field)this.field);
            Object orivalue = ReflectionUtils.getField((Field)this.field, (Object)this.bean);
            return String.format("%-20s %40s.%-40s %-20s %-10s", ArraysUtil.deepToString(orivalue), this.bean.getClass().getSimpleName(), this.field.getName(), this.resetable ? "RESETABLE" : "", this.setter != null ? "SETTER" : "");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.bean == null ? 0 : this.bean.getClass().hashCode());
            result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigField other = (ConfigField)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.bean == null ? other.bean != null : !this.bean.getClass().equals(other.bean.getClass())) {
                return false;
            }
            if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
                return false;
            }
            return !(this.field == null ? other.field != null : !this.field.equals(other.field));
        }

        private ConfigBeanPostProcessor getOuterType() {
            return ConfigBeanPostProcessor.this;
        }
    }

    private class ConfigEntry {
        private Set<ConfigField> configFields = new LinkedHashSet<ConfigField>(2);
        private boolean guarded;
        private String key;

        public ConfigEntry(String key) {
            this.key = key;
        }

        public synchronized void addField(ConfigField f) {
            this.configFields.remove(f);
            this.configFields.add(f);
        }
    }
}

