/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util;

import com.xunlei.netty.util.CloseableHelper;
import com.xunlei.netty.util.ValueUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class StringTools {
    private static final String[] STRING_ESCAPE_LIST = new String[93];
    private static final String[] SQL_LIKE_PATTERN;
    private static final Set<String> visibleCharacters;

    public static boolean isBlank(CharSequence str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotBlank(CharSequence str) {
        return !StringTools.isBlank(str);
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StringTools.isEmpty(str);
    }

    public static boolean isNotNumberStr(CharSequence str) {
        return !StringTools.isNumberStr(str);
    }

    public static boolean isNumberStr(CharSequence str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String removeNewLines(String src) {
        if (StringTools.isNotEmpty(src)) {
            return src.replace("\n", "").replace("\r", "");
        }
        return "";
    }

    public static List<String> splitAndTrim(String str, String regex) {
        String[] arr = str.split(regex);
        ArrayList<String> list = new ArrayList<String>(arr.length);
        for (String a : arr) {
            String add = a.trim();
            if (add.length() <= 0) continue;
            list.add(add);
        }
        return list;
    }

    public static Collection<String> splitAndTrim(String str, String regex, Collection<String> result) {
        String[] arr;
        for (String a : arr = str.split(regex)) {
            String add = a.trim();
            if (add.length() <= 0) continue;
            result.add(add);
        }
        return result;
    }

    public static <T> Collection<T> splitAndTrim(String str, String regex, Collection<T> result, Class<T> componentClazz) {
        String[] arr;
        Method method = ValueUtil.getValueOfMethod(componentClazz);
        for (String a : arr = str.split(regex)) {
            String add = a.trim();
            if (add.length() <= 0) continue;
            try {
                result.add(method.invoke(null, add));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String[] splitAndTrimAsArray(String str, String regex) {
        return StringTools.splitAndTrim(str, regex).toArray(ValueUtil.REF_ARRAY_STRING);
    }

    public static <T> Object splitAndTrimAsArray(String str, String regex, Class<T> componentClazz) {
        return ValueUtil.toArray(StringTools.splitAndTrim(str, regex, new ArrayList(2), componentClazz), componentClazz);
    }

    public static String escapeHtml(String source) {
        if (StringTools.isNotEmpty(source)) {
            return source.replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace(" ", "&nbsp;").replace("\n", "<br/>").replace("\r", "").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        return "";
    }

    public static String escapeXml(String source) {
        if (StringTools.isNotEmpty(source)) {
            return source.replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("&", "&amp;").replace("'", "&apos;");
        }
        return "";
    }

    public static String truncate(String source, int length) {
        if (StringTools.isEmpty(source) || length <= 0) {
            return source;
        }
        return source.length() > length ? source.substring(0, length) : source;
    }

    public static String escapeString(String source) {
        if (StringTools.isNotEmpty(source)) {
            StringBuilder sb = new StringBuilder(source.length() + 16);
            for (int i = 0; i < source.length(); ++i) {
                char ch = source.charAt(i);
                if (ch < STRING_ESCAPE_LIST.length) {
                    String append = STRING_ESCAPE_LIST[ch];
                    sb.append(null != append ? append : Character.valueOf(ch));
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        return "";
    }

    public static <T> T[] splitAndTrimAsArray(String str, String regex, T[] refArray) {
        return ValueUtil.toArray(StringTools.splitAndTrim(str, regex, new ArrayList(2), refArray.getClass().getComponentType()), refArray);
    }

    public static StringBuilder clearStringBuilder(StringBuilder sb) {
        sb.delete(0, sb.length());
        return sb;
    }

    public static StringBuilder subStringBuilder(StringBuilder sb, int start, int end) {
        int count = sb.length();
        if (end < count) {
            sb.delete(end, count);
        }
        if (start > 0) {
            sb.delete(0, start);
        }
        return sb;
    }

    public static StringBuilder subStringBuilder(StringBuilder sb, int start) {
        if (start > 0) {
            sb.delete(0, start);
        }
        return sb;
    }

    private StringTools() {
    }

    public static String trim(String str) {
        int st;
        if (StringTools.isEmpty(str)) {
            return "";
        }
        int len = str.length();
        int count = str.length();
        for (st = 0; st < len && (str.charAt(st) <= ' ' || str.charAt(st) == '\u3000'); ++st) {
        }
        while (st < len && (str.charAt(len - 1) <= ' ' || str.charAt(len - 1) == '\u3000')) {
            --len;
        }
        return st > 0 || len < count ? str.substring(st, len) : str;
    }

    public static String escapeSqlLikePattern(String keyword) {
        if (StringTools.isEmpty(keyword)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(keyword.length());
        for (int i = 0; i < keyword.length(); ++i) {
            char ch = keyword.charAt(i);
            if (ch < SQL_LIKE_PATTERN.length) {
                String append = SQL_LIKE_PATTERN[ch];
                sb.append(null != append ? append : Character.valueOf(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static boolean hasInvalidCharacter(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(ch);
            if (null != ub && visibleCharacters.contains(ub.toString())) continue;
            return true;
        }
        return false;
    }

    public static String smartDecode(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        String charset = "GB18030";
        int read = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((read = bis.read()) != -1) {
            baos.write(read);
            if (read >= 240 || 128 <= read && read <= 191) break;
            if (192 <= read && read <= 223) {
                read = bis.read();
                if (read == -1) break;
                baos.write(read);
                if (128 > read || read > 191) break;
                continue;
            }
            if (224 > read || read > 239) continue;
            read = bis.read();
            if (read == -1) break;
            baos.write(read);
            if (128 > read || read > 191 || (read = bis.read()) == -1) break;
            baos.write(read);
            if (128 > read || read > 191) break;
            charset = "UTF-8";
            break;
        }
        while ((read = bis.read()) != -1) {
            baos.write(read);
        }
        byte[] data = baos.toByteArray();
        CloseableHelper.closeSilently(baos);
        try {
            return new String(data, charset);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String detectCharset(byte[] data) {
        String output = "";
        try {
            output = new String(data, "UTF-8");
            if (!StringTools.hasInvalidCharacter(output)) {
                return "UTF-8";
            }
            output = new String(data, "BIG5");
            if (!StringTools.hasInvalidCharacter(output)) {
                return "BIG5";
            }
            output = new String(data, "EUC-KR");
            if (!StringTools.hasInvalidCharacter(output)) {
                return "EUC-KR";
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "GB18030";
    }

    static {
        StringTools.STRING_ESCAPE_LIST[92] = "\\\\";
        StringTools.STRING_ESCAPE_LIST[34] = "\\\"";
        StringTools.STRING_ESCAPE_LIST[39] = "\\'";
        StringTools.STRING_ESCAPE_LIST[13] = "\\r";
        StringTools.STRING_ESCAPE_LIST[10] = "\\n";
        StringTools.STRING_ESCAPE_LIST[12] = "\\f";
        StringTools.STRING_ESCAPE_LIST[9] = "\\t";
        StringTools.STRING_ESCAPE_LIST[8] = "\\b";
        SQL_LIKE_PATTERN = new String[96];
        StringTools.SQL_LIKE_PATTERN[37] = "\\%";
        StringTools.SQL_LIKE_PATTERN[95] = "\\_";
        visibleCharacters = new HashSet<String>();
        visibleCharacters.add(Character.UnicodeBlock.BASIC_LATIN.toString());
        visibleCharacters.add(Character.UnicodeBlock.GENERAL_PUNCTUATION.toString());
        visibleCharacters.add(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION.toString());
        visibleCharacters.add(Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS.toString());
        visibleCharacters.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS.toString());
        visibleCharacters.add(Character.UnicodeBlock.HANGUL_SYLLABLES.toString());
        visibleCharacters.add(Character.UnicodeBlock.HIRAGANA.toString());
        visibleCharacters.add(Character.UnicodeBlock.KATAKANA.toString());
        visibleCharacters.add(Character.UnicodeBlock.DINGBATS.toString());
        visibleCharacters.add(Character.UnicodeBlock.SMALL_FORM_VARIANTS.toString());
        visibleCharacters.add(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS.toString());
        visibleCharacters.add(Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS.toString());
        visibleCharacters.add(Character.UnicodeBlock.NUMBER_FORMS.toString());
        visibleCharacters.add(Character.UnicodeBlock.ENCLOSED_ALPHANUMERICS.toString());
        visibleCharacters.add(Character.UnicodeBlock.MATHEMATICAL_OPERATORS.toString());
        visibleCharacters.add(Character.UnicodeBlock.LATIN_1_SUPPLEMENT.toString());
        visibleCharacters.add(Character.UnicodeBlock.GREEK.toString());
        visibleCharacters.add(Character.UnicodeBlock.CJK_COMPATIBILITY.toString());
        visibleCharacters.add(Character.UnicodeBlock.SPACING_MODIFIER_LETTERS.toString());
        visibleCharacters.add(Character.UnicodeBlock.MISCELLANEOUS_TECHNICAL.toString());
        visibleCharacters.add(Character.UnicodeBlock.SUPERSCRIPTS_AND_SUBSCRIPTS.toString());
        visibleCharacters.add(Character.UnicodeBlock.LETTERLIKE_SYMBOLS.toString());
        visibleCharacters.add(Character.UnicodeBlock.GEOMETRIC_SHAPES.toString());
        visibleCharacters.add(Character.UnicodeBlock.CYRILLIC.toString());
        visibleCharacters.add(Character.UnicodeBlock.LATIN_EXTENDED_A.toString());
        visibleCharacters.add(Character.UnicodeBlock.LATIN_EXTENDED_B.toString());
        visibleCharacters.add(Character.UnicodeBlock.BOPOMOFO.toString());
        visibleCharacters.add(Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO.toString());
        visibleCharacters.add(Character.UnicodeBlock.IPA_EXTENSIONS.toString());
        visibleCharacters.add(Character.UnicodeBlock.BOX_DRAWING.toString());
        visibleCharacters.add(Character.UnicodeBlock.MISCELLANEOUS_SYMBOLS.toString());
        visibleCharacters.add(Character.UnicodeBlock.BLOCK_ELEMENTS.toString());
        visibleCharacters.add(Character.UnicodeBlock.ARABIC.toString());
        visibleCharacters.add(Character.UnicodeBlock.THAI.toString());
        visibleCharacters.add(Character.UnicodeBlock.ARROWS.toString());
    }
}

