/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Map;

public class StringHelper {
    private static Method getOurStackTrace;

    public static StringBuilder append(StringBuilder tmp, Object ... args) {
        for (Object s : args) {
            tmp.append(s);
        }
        return tmp;
    }

    public static String concate(Object ... args) {
        if (args.length < 4) {
            String result = "";
            for (Object s : args) {
                result = result + s;
            }
            return result;
        }
        return StringHelper.append(new StringBuilder(), args).toString();
    }

    public static <K, V> String concateKeyValue(KeyValueStringBuilder keyValueStringBuilder, Map<K, V> keyvalue) {
        return StringHelper.concateKeyValue(new StringBuilder(), keyValueStringBuilder, keyvalue).toString();
    }

    public static <K, V> StringBuilder concateKeyValue(StringBuilder tmp, KeyValueStringBuilder keyValueStringBuilder, Map<K, V> keyvalue) {
        for (Map.Entry<K, V> entry : keyvalue.entrySet()) {
            keyValueStringBuilder.append(tmp, entry.getKey(), entry.getValue());
        }
        return tmp;
    }

    public static String concateWithSplit(String splitStr, Object ... args) {
        return StringHelper.concateWithSplit(new StringBuilder(), splitStr, args).toString();
    }

    public static StringBuilder concateWithSplit(StringBuilder tmp, String splitStr, Object ... args) {
        if (args.length == 0) {
            return tmp;
        }
        int endIndex = args.length - 1;
        for (int i = 0; i < endIndex; ++i) {
            tmp.append(args[i]).append(splitStr);
        }
        tmp.append(args[endIndex]);
        return tmp;
    }

    public static StringBuilder emphasizeTitle(String title, char corner, char linechar, char verticalchar) {
        return StringHelper.emphasizeTitle(new StringBuilder(), title, corner, linechar, verticalchar);
    }

    public static StringBuilder emphasizeTitle(StringBuilder tmp, String title, char corner, char linechar, char verticalchar) {
        try {
            StringBuilder line = StringHelper.printLine(title.getBytes("GBK").length, corner, linechar);
            tmp.append((CharSequence)line);
            tmp.append(verticalchar).append(title).append(verticalchar).append('\n');
            tmp.append((CharSequence)line);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return tmp;
    }

    private static StackTraceElement[] getOurStackTrace(Throwable ex) {
        try {
            StackTraceElement[] ste = (StackTraceElement[])getOurStackTrace.invoke((Object)ex, new Object[0]);
            return ste;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static StringBuilder printLine(int len, char linechar) {
        return StringHelper.printLine(new StringBuilder(), len, linechar);
    }

    public static StringBuilder printLine(int len, char corner, char linechar) {
        return StringHelper.printLine(new StringBuilder(), len, corner, linechar);
    }

    public static StringBuilder printLine(StringBuilder tmp, int len, char linechar) {
        for (int i = 0; i < len; ++i) {
            tmp.append(linechar);
        }
        tmp.append('\n');
        return tmp;
    }

    public static StringBuilder printLine(StringBuilder tmp, int len, char corner, char linechar) {
        tmp.append(corner);
        for (int i = 0; i < len; ++i) {
            tmp.append(linechar);
        }
        tmp.append(corner);
        tmp.append('\n');
        return tmp;
    }

    public static StringBuilder printThrowable(StringBuilder tmp, Throwable ex) {
        if (null != ex) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(stringWriter);
            ex.printStackTrace(pw);
            tmp.append(stringWriter).append('\n');
        }
        return tmp;
    }

    public static StringBuilder printThrowable(Throwable ex) {
        return StringHelper.printThrowable(new StringBuilder(), ex);
    }

    public static String printThrowableSimple(Throwable ex) {
        return StringHelper.printThrowableSimple(ex, 8);
    }

    public static String printThrowableSimple(Throwable ex, int maxTraceLen) {
        if (null != ex) {
            StackTraceElement[] trace;
            StringBuilder s = new StringBuilder();
            s.append(ex.getClass().getSimpleName());
            s.append(":");
            s.append(ex.getMessage());
            if (maxTraceLen > 0 && (trace = StringHelper.getOurStackTrace(ex)) != null) {
                int len = Math.min(trace.length, maxTraceLen);
                for (int i = 0; i < len; ++i) {
                    try {
                        StackTraceElement t = trace[i];
                        String clazzName = t.getClassName();
                        clazzName = clazzName.substring(clazzName.lastIndexOf(".") + 1, clazzName.length());
                        s.append("||");
                        s.append(clazzName);
                        s.append(".");
                        s.append(t.getMethodName());
                        s.append(":");
                        s.append(t.getLineNumber());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return s.toString();
        }
        return "";
    }

    public static StringBuilder printStackTraceSimple() {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        if (ste != null) {
            for (int i = 0; i < ste.length; ++i) {
                try {
                    StackTraceElement t = ste[i];
                    String clazzName = t.getClassName();
                    if (clazzName.equals(StringHelper.class.getName()) || clazzName.equals(Thread.class.getName()) && t.getMethodName().equals("getStackTrace")) continue;
                    clazzName = clazzName.substring(clazzName.lastIndexOf(".") + 1, clazzName.length());
                    sb.append("||");
                    sb.append(clazzName);
                    sb.append(".");
                    sb.append(t.getMethodName());
                    sb.append(":");
                    sb.append(t.getLineNumber());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return sb;
    }

    private static StringBuilder fixHexString(StringBuilder buf, String hexStr, int length) {
        if (hexStr == null || hexStr.length() == 0) {
            buf.append("00000000h");
        } else {
            int strLen = hexStr.length();
            for (int i = 0; i < length - strLen; ++i) {
                buf.append("0");
            }
            buf.append(hexStr).append("h");
        }
        return buf;
    }

    private static String filterString(byte[] bytes, int offset, int count) {
        byte[] buffer = new byte[count];
        System.arraycopy(bytes, offset, buffer, 0, count);
        for (int i = 0; i < count; ++i) {
            if (buffer[i] < 0 || buffer[i] > 31) continue;
            buffer[i] = 46;
        }
        return new String(buffer);
    }

    public static String digestString(String src) {
        return StringHelper.digestString(src, 50);
    }

    public static String digestString(String src, int lengthThreshold) {
        if (src.length() > lengthThreshold * 2 + 20) {
            return src.substring(0, lengthThreshold) + "...(" + src.length() + ")..." + src.substring(src.length() - lengthThreshold, src.length());
        }
        return src;
    }

    private StringHelper() {
    }

    static {
        try {
            getOurStackTrace = Throwable.class.getDeclaredMethod("getOurStackTrace", new Class[0]);
            getOurStackTrace.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface KeyValueStringBuilder {
        public void append(StringBuilder var1, Object var2, Object var3);
    }
}

