/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util;

import com.xunlei.channel.util.Md5Encrypt;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class SignUtil {
    public static boolean checkSign(Map param, String privateKey) {
        if (StringUtils.isBlank((String)privateKey) || param == null) {
            return false;
        }
        String signMsg = (String)param.get("signMsg");
        if (StringUtils.isBlank((String)signMsg)) {
            return false;
        }
        String signed = SignUtil.sign(param, privateKey);
        return signMsg.equals(signed);
    }

    public static String sign(String content, String privateKey) {
        if (content == null) {
            return null;
        }
        return Md5Encrypt.md5((String)(content + privateKey));
    }

    public static String sign(Map<String, String> param, String privateKey, String encodeCharset) {
        return SignUtil.sign(SignUtil.getSignatureContent(param, encodeCharset), privateKey);
    }

    public static String sign(Map<String, String> param, String privateKey) {
        return SignUtil.sign(SignUtil.getSignatureContent(param), privateKey);
    }

    public static String getSignatureContent(Map<String, String> param) {
        return SignUtil.getSignatureContent(param, null);
    }

    public static String getSignatureContent(Map<String, String> param, String encodeCharset) {
        Properties prop = new Properties();
        for (String key : param.keySet()) {
            String value;
            if (key.equals("signMsg") || (value = param.get(key)) == null || "".equals(value)) continue;
            prop.setProperty(key, value);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> keys = new ArrayList<Object>(prop.keySet());
        Collections.sort((List)keys);
        for (int i = 0; i < ((List)keys).size(); ++i) {
            String key = (String)((List)keys).get(i);
            String value = prop.getProperty(key);
            if (encodeCharset != null && !"".equals(encodeCharset)) {
                try {
                    value = URLEncoder.encode(prop.getProperty(key), encodeCharset);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sb.append(i == 0 ? "" : "&");
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static String urlEncode(String value, String charset) {
        try {
            return URLEncoder.encode(value, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

