/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util;

import com.dianping.cat.Cat;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.util.IPGetter;
import com.xunlei.netty.util.StringTools;

public class IPGetterHelper {
    public static final IPGetter DEFAULT_IPGETTER;
    private static IPGetter CURRENT_IPGETTER;
    public static final String PROXY_CLIENT_IP = "Proxy-Client-IP";
    public static final String WL_PROXY_CLIENT_IP = "WL-Proxy-Client-IP";
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";
    public static final String X_REAL_IP = "X-Real-IP";

    public static String getIP(XLHttpRequest request) {
        return CURRENT_IPGETTER.getIP(request);
    }

    public static void setIPGetter(IPGetter getter) {
        if (getter != null) {
            CURRENT_IPGETTER = getter;
        }
    }

    public static String getIP(XLHttpRequest request, String proxyHeader) {
        String proxyIp = request.getHeader(proxyHeader);
        if (proxyIp == null) {
            return request.getPrimitiveRemoteIP();
        }
        if ((proxyIp = proxyIp.trim()).isEmpty() || !proxyIp.contains(".")) {
            return request.getPrimitiveRemoteIP();
        }
        return proxyIp;
    }

    public static String getIPByXForwared(XLHttpRequest request) {
        String proxyIp = request.getHeader(X_FORWARDED_FOR);
        if (proxyIp == null) {
            return request.getPrimitiveRemoteIP();
        }
        if ((proxyIp = proxyIp.trim()).isEmpty() || !proxyIp.contains(".")) {
            return request.getPrimitiveRemoteIP();
        }
        int index = proxyIp.indexOf(44);
        if (index > 0) {
            proxyIp = proxyIp.substring(0, index).trim();
        }
        return proxyIp;
    }

    public static String getIP(XLHttpRequest request, String ... proxyHeaders) {
        for (int i = 0; i < proxyHeaders.length; ++i) {
            String proxyIp = request.getHeader(proxyHeaders[i]);
            if (proxyIp == null) continue;
            int index = (proxyIp = proxyIp.trim()).lastIndexOf(44);
            if (index > 0 && index < proxyIp.length()) {
                proxyIp = proxyIp.substring(index + 1, proxyIp.length()).trim();
            }
            if (null == proxyIp || proxyIp.isEmpty() || !proxyIp.contains(".")) continue;
            return proxyIp;
        }
        return request.getPrimitiveRemoteIP();
    }

    public static String getRequestIp(XLHttpRequest request) {
        String ip = "";
        try {
            ip = request.getHeader("x-forwarded-for");
            Cat.logEvent((String)"Other", (String)"getRequestIp.x-forwarded-for");
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader(PROXY_CLIENT_IP);
                Cat.logEvent((String)"Other", (String)"getRequestIp.Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader(WL_PROXY_CLIENT_IP);
                Cat.logEvent((String)"Other", (String)"getRequestIp.WL-Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getPrimitiveRemoteIP();
                Cat.logEvent((String)"Other", (String)"getRequestIp.getPrimitiveRemoteIP");
            }
            if (!StringTools.isEmpty(ip) && ip.length() > 15) {
                ip = request.getRemoteIP();
                Cat.logEvent((String)"Other", (String)"getRequestIp.getRemoteIP");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ip;
    }

    static {
        CURRENT_IPGETTER = DEFAULT_IPGETTER = new DefaultIPGetter();
    }

    private static class DefaultIPGetter
    implements IPGetter {
        private DefaultIPGetter() {
        }

        @Override
        public String getIP(XLHttpRequest request) {
            return request.getPrimitiveRemoteIP();
        }
    }
}

