/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.util;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class HtmlUtil {
    private static StringBuilder htmlTemplate = HtmlUtil.getHtmlTemplate();

    private static StringBuilder getHtmlTemplate() {
        if (htmlTemplate == null) {
            htmlTemplate = new StringBuilder();
            htmlTemplate.append("<!DOCTYPE html>");
            htmlTemplate.append("<html lang='zh-CN'>");
            htmlTemplate.append("  <head>");
            htmlTemplate.append("    <meta charset='utf-8'>");
            htmlTemplate.append("    <meta http-equiv='X-UA-Compatible' content='IE=edge'>");
            htmlTemplate.append("    <meta name='viewport' content='width=device-width, initial-scale=1'>");
            htmlTemplate.append("    <!-- Bootstrap -->");
            htmlTemplate.append("\t<!-- \u65b0 Bootstrap \u6838\u5fc3 CSS \u6587\u4ef6 -->");
            htmlTemplate.append("\t<link rel='stylesheet' href='http://cdn.bootcss.com/bootstrap/3.3.5/css/bootstrap.min.css'>");
            htmlTemplate.append("    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->");
            htmlTemplate.append("    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->");
            htmlTemplate.append("    <!--[if lt IE 9]>");
            htmlTemplate.append("      <script src='//cdn.bootcss.com/html5shiv/3.7.2/html5shiv.min.js'></script>");
            htmlTemplate.append("      <script src='//cdn.bootcss.com/respond.js/1.4.2/respond.min.js'></script>");
            htmlTemplate.append("    <![endif]-->");
            htmlTemplate.append("  </head>");
            htmlTemplate.append("  <body>");
            htmlTemplate.append("\t{body}");
            htmlTemplate.append("  </body>");
            htmlTemplate.append("</html>");
        }
        return htmlTemplate;
    }

    public static String getHtmlTable(List<Map<String, String>> tableData) {
        StringBuilder htmlTable = new StringBuilder();
        if (tableData != null && tableData.size() > 0) {
            htmlTable.append("<table class='table table-hover'>");
            htmlTable.append("<thead>");
            htmlTable.append("<tr>");
            htmlTable.append("<th>#</th>");
            for (String string : tableData.get(0).keySet()) {
                htmlTable.append("<th>").append(string).append("</th>");
            }
            htmlTable.append("</tr>");
            htmlTable.append("</thead>");
            htmlTable.append("<tbody>");
            for (Map map : tableData) {
                htmlTable.append("<tr>");
                htmlTable.append("<th scope='row'>").append(tableData.indexOf(map) + 1).append("</th>");
                for (Map.Entry map2 : map.entrySet()) {
                    htmlTable.append("<td>").append((String)map2.getValue()).append("</td>");
                }
                htmlTable.append("</tr>");
            }
            htmlTable.append("</tbody>");
            htmlTable.append("</table>");
        }
        return StringUtils.replace((String)htmlTemplate.toString(), (String)"{body}", (String)htmlTable.toString());
    }

    public static String getHtmlLink(String name, String url) {
        String html = "<a href='{url}' target='_blank'>{name}</a></td>";
        return html.replace("{name}", name).replace("{url}", url);
    }

    public static String getHtmlLink(String url) {
        return HtmlUtil.getHtmlLink(url, url);
    }

    public static String getHtmlForm(String formContent, String actionUrl) {
        String html = "<form action='{actionUrl}' method='get'>{formContent}<input class='btn btn-primary' type='submit' value='\u63d0\u4ea4 '/></form>";
        return html.replace("{formContent}", formContent).replace("{actionUrl}", actionUrl);
    }

    public static String getHtmlRadio(String radioName, List<String> radioList, String currrentRadio) {
        StringBuilder html = new StringBuilder();
        if (radioList != null && radioList.size() > 0) {
            for (String string : radioList) {
                html.append("<input type='radio' name='").append(radioName).append("' value='").append(string).append("'");
                if (string.equals(currrentRadio)) {
                    html.append(" checked ");
                }
                html.append(" />");
                html.append(string);
            }
        }
        return html.toString();
    }

    public static String getInputHidden(String name, String value) {
        String html = "<input type='hidden' name='{name}' value='{value}' />";
        return html.replace("{name}", name).replace("{value}", value);
    }

    public static String getInputText(String name, String value) {
        String html = "<input type='text' class='form-control' name='{name}' value='{value}' style='display:inline;width:20%;'/>";
        return html.replace("{name}", name).replace("{value}", value);
    }
}

