/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.soaserver.component;

import com.xunlei.netty.grpcserver.client.GRPCClientFactory;
import com.xunlei.netty.soaserver.client.SOAClientFactory;
import com.xunlei.netty.soaserver.cmd.common.ISOACmdService;
import com.xunlei.netty.soaserver.component.RpcOutput;
import com.xunlei.netty.soaserver.component.SOAServiceBase;
import com.xunlei.netty.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class SOAServiceCmdFactory
extends SOAServiceBase {
    private static final Logger log = Log.getLogger();
    private static List<SOAServiceCmdFactory> soaServiceCmdFactoryList = new ArrayList<SOAServiceCmdFactory>();
    private SOAClientFactory soaClientFactory = this.newSOAClientFactory();
    private GRPCClientFactory grpcClientFactory;
    private ISOACmdService soaCmdService;

    public SOAServiceCmdFactory(String appName, String configUrl) {
        super(appName, configUrl);
        soaServiceCmdFactoryList.add(this);
        this.grpcClientFactory = new GRPCClientFactory(this);
    }

    private SOAClientFactory newSOAClientFactory() {
        SOAClientFactory soaClient = new SOAClientFactory(this);
        this.soaCmdService = (ISOACmdService)soaClient.getObject(ISOACmdService.class);
        return soaClient;
    }

    public Object invokeRpcOutput(RpcOutput rpcOutput) throws Exception {
        return this.soaClientFactory.newInterfaceProxyBase(null).invoke(rpcOutput);
    }

    protected SOAClientFactory getSoaClientFactory() {
        return this.soaClientFactory;
    }

    public GRPCClientFactory getGrpcClientFactory() {
        return this.grpcClientFactory;
    }

    public ISOACmdService getSoaCmdService() {
        return this.soaCmdService;
    }

    public static List<SOAServiceCmdFactory> getSoaServiceCmdFactoryList() {
        return soaServiceCmdFactoryList;
    }
}

