/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.soaserver.cmd;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.netty.httpserver.cmd.BaseCmd;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.model.CookieInfo;
import com.xunlei.netty.soaserver.component.GenericBase;
import com.xunlei.netty.soaserver.component.SOAListResponse;
import com.xunlei.netty.soaserver.component.SOAPageResponse;
import com.xunlei.netty.soaserver.component.SOAResponse;
import com.xunlei.netty.util.SignUtil;
import com.xunlei.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;

public abstract class BaseSOACmd {
    private static Logger logger = Log.getLogger((String)BaseSOACmd.class.getName());

    protected <T> T getSOAByHTTP(Class<T> classType, BaseCmd httpCmd, String methodName, Map<String, String> param) throws Exception {
        return this.getSOAByHTTPWithCookie(classType, httpCmd, methodName, param, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T getSOAByHTTPWithCookie(Class<T> classType, BaseCmd httpCmd, String methodName, Map<String, String> param, CookieInfo cookieInfo) throws Exception {
        JsonObject jsonObject;
        int code;
        Object resultObject = null;
        Object resultMsg = this.getHTTPMethodResultWithCookie(httpCmd, methodName, param, cookieInfo);
        if (resultMsg == null) throw new XLRuntimeException("resultMsg\u4e3a\u7a7a");
        String resultMsgStr = resultMsg.toString().trim();
        if (!resultMsgStr.startsWith("{")) {
            resultMsgStr = resultMsgStr.substring(resultMsgStr.indexOf("{"), resultMsgStr.length() - 1);
        }
        if ((code = (jsonObject = new JsonParser().parse(resultMsgStr).getAsJsonObject()).get("rtn").getAsInt()) == 0) {
            if (classType == null) return (T)resultObject;
            Gson gson = new Gson();
            resultObject = gson.fromJson(jsonObject.get("data"), classType);
            return (T)resultObject;
        } else {
            String msg = jsonObject.get("data").getAsString();
            throw new XLRuntimeException(msg);
        }
    }

    protected <T> SOAResponse<T> getSOAResponseByHTTP(Class<T> classType, BaseCmd httpCmd, String methodName, Map<String, String> param) throws Exception {
        SOAResponse<Object> resultObject = null;
        Object resultMsg = this.getHTTPMethodResult(httpCmd, methodName, param);
        if (resultMsg != null) {
            resultObject = new SOAResponse<Object>((Class<?>)classType);
            JsonObject jsonObject = new JsonParser().parse(resultMsg.toString()).getAsJsonObject();
            int code = jsonObject.get("rtn").getAsInt();
            resultObject.setRtn(code);
            if (code == 0) {
                if (classType != null) {
                    Gson gson = new Gson();
                    resultObject.setData(gson.fromJson(jsonObject.get("data"), classType));
                }
            } else {
                String msg = jsonObject.get("data").getAsString();
                resultObject.setMsg(msg);
            }
        }
        return resultObject;
    }

    protected <T> SOAListResponse<T> getSOAListResponseByHTTP(Class<T> classType, BaseCmd httpCmd, String methodName, Map<String, String> param) throws Exception {
        SOAListResponse resultObject = null;
        Object resultMsg = this.getHTTPMethodResult(httpCmd, methodName, param);
        if (resultMsg != null) {
            resultObject = new SOAListResponse((Class<?>)classType);
            JsonObject jsonObject = new JsonParser().parse(resultMsg.toString()).getAsJsonObject();
            int code = jsonObject.get("rtn").getAsInt();
            resultObject.setRtn(code);
            if (code == 0) {
                if (classType != null) {
                    Gson gson = new Gson();
                    JsonObject jsonPages = jsonObject.get("data").getAsJsonObject();
                    ParameterizedType dataListType = GenericBase.getType(List.class, classType);
                    resultObject.setDataList((List)gson.fromJson((JsonElement)jsonPages, (Type)dataListType));
                }
            } else {
                String msg = jsonObject.get("data").getAsString();
                resultObject.setMsg(msg);
            }
        }
        return resultObject;
    }

    protected <T> SOAPageResponse<T> getSOAPageResponseByHTTP(Class<T> classType, BaseCmd httpCmd, String methodName, Map<String, String> param) throws Exception {
        return this.getSOAPageResponseByHTTP(classType, httpCmd, methodName, param, null, null);
    }

    protected <T> SOAPageResponse<T> getSOAPageResponseByHTTP(Class<T> classType, BaseCmd httpCmd, String methodName, Map<String, String> param, String pageDatasKey, String totalCountKey) throws Exception {
        SOAPageResponse resultObject = null;
        Object resultMsg = this.getHTTPMethodResult(httpCmd, methodName, param);
        if (resultMsg != null) {
            resultObject = new SOAPageResponse((Class<?>)classType);
            JsonObject jsonObject = new JsonParser().parse(resultMsg.toString()).getAsJsonObject();
            int code = jsonObject.get("rtn").getAsInt();
            resultObject.setRtn(code);
            if (code == 0) {
                if (classType != null) {
                    JsonObject jsonPages = jsonObject.get("data").getAsJsonObject();
                    if (StringUtils.isBlank((String)pageDatasKey)) {
                        pageDatasKey = "pageDatas";
                    }
                    if (StringUtils.isBlank((String)totalCountKey)) {
                        totalCountKey = "totalCount";
                    }
                    Gson gson = new Gson();
                    resultObject.setTotalCount(jsonPages.get(totalCountKey).getAsInt());
                    ParameterizedType pageDatasType = GenericBase.getType(List.class, classType);
                    resultObject.setPageDatas((List)gson.fromJson(jsonPages.get(pageDatasKey), (Type)pageDatasType));
                }
            } else {
                String msg = jsonObject.get("data").getAsString();
                resultObject.setMsg(msg);
            }
        }
        return resultObject;
    }

    protected Object getHTTPMethodResult(BaseCmd httpCmd, String methodName, Map<String, String> param) throws Exception {
        return this.getHTTPMethodResultWithCookie(httpCmd, methodName, param, null);
    }

    protected Object getHTTPMethodResultWithCookie(BaseCmd httpCmd, String methodName, Map<String, String> param, CookieInfo cookieInfo) throws Exception {
        Method method;
        if (StringUtils.isBlank((String)methodName)) {
            throw new XLRuntimeException("\u8bf7\u6c42\u65b9\u6cd5\u4e3a\u7a7a");
        }
        if (httpCmd == null) {
            throw new XLRuntimeException("\u8bf7\u6c42\u5bf9\u8c61\u4e3a\u7a7a");
        }
        String uri = "?";
        if (param != null && param.size() > 0) {
            String paramStr = SignUtil.getSignatureContent(param);
            uri = uri + paramStr;
        }
        if ((method = httpCmd.getClass().getMethod(methodName, XLHttpRequest.class, XLHttpResponse.class)) == null) {
            throw new XLRuntimeException("\u65b9\u6cd5\u4e0d\u5b58\u5728 methodName\uff1a" + methodName);
        }
        logger.debug("Http\u63a5\u53e3\u8f6cSOA\u63a5\u53e3[getSOAByHTTP] uri:" + uri);
        XLHttpRequest request = new XLHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.GET, uri);
        request.setHeader("x-forwarded-for", "127.0.0.1");
        request.setHeader("X-real-IP", "127.0.0.1");
        if (cookieInfo != null) {
            request.setHeader("Cookie", cookieInfo.toString());
        }
        XLHttpResponse response = new XLHttpResponse();
        Object resultMsg = method.invoke((Object)httpCmd, new Object[]{request, response});
        logger.debug("Http\u63a5\u53e3\u8f6cSOA\u63a5\u53e3[getSOAByHTTP] resultMsg:" + resultMsg);
        return resultMsg;
    }

    protected Map<String, String> getMapByObject(Object obj) throws Exception {
        Class<?> classType;
        Field[] fieldArray;
        HashMap<String, String> result = new HashMap<String, String>();
        if (obj != null && (fieldArray = (classType = obj.getClass()).getDeclaredFields()) != null && fieldArray.length > 0) {
            for (Field field : fieldArray) {
                field.setAccessible(true);
                String key = field.getName();
                Object value = field.get(obj);
                if (value == null) continue;
                result.put(key, String.valueOf(value));
            }
        }
        return result;
    }
}

