/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.soaserver;

import com.xunlei.netty.BootstrapFactory;
import com.xunlei.netty.httpserver.component.NOPDispatcher;
import com.xunlei.netty.soaserver.component.BaseSOAPageDispatcher;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.spring.AfterConfig;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.LineBasedFrameDecoder;
import org.jboss.netty.handler.codec.string.StringDecoder;
import org.jboss.netty.handler.codec.string.StringEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SOAServerPipelineFactory
implements ChannelPipelineFactory {
    private static final Logger log = Log.getLogger();
    @Autowired
    private NettyServerConfig config;
    @Autowired
    private BootstrapFactory bootstrap;
    private ExecutionHandler executionHandler;
    @Autowired
    private NOPDispatcher nopDispatcher;
    @Autowired
    private BaseSOAPageDispatcher pageDispatcher;
    private StringEncoder encoder = new StringEncoder();

    @AfterConfig
    public void init() {
        this.executionHandler = new ExecutionHandler((Executor)this.config.getPipelineExecutor());
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        log.debug("Netty\u670d\u52a1.SOA\u8bf7\u6c42.\u7ba1\u9053\u521d\u59cb\u5316.getPipeline()");
        if (this.bootstrap.isStop()) {
            pipeline.addLast("nop", (ChannelHandler)this.nopDispatcher);
            return pipeline;
        }
        pipeline.addLast("framedecoder", (ChannelHandler)new LineBasedFrameDecoder(Integer.MAX_VALUE));
        pipeline.addLast("decoder", (ChannelHandler)new StringDecoder());
        pipeline.addLast("encoder", (ChannelHandler)this.encoder);
        pipeline.addLast("pageDispatcher", (ChannelHandler)this.pageDispatcher);
        String addBefore = this.config.getPlAddBefore();
        if (addBefore != null) {
            if (addBefore.isEmpty()) {
                pipeline.addFirst("executor", (ChannelHandler)this.executionHandler);
            } else {
                try {
                    pipeline.addBefore(addBefore, "executor", (ChannelHandler)this.executionHandler);
                }
                catch (NoSuchElementException e) {
                    log.error("config error,config.plAddBefore:{} NOT FOUND,execption:{}", (Object)addBefore, (Object)e);
                    pipeline.addFirst("executor", (ChannelHandler)this.executionHandler);
                }
            }
        }
        return pipeline;
    }

    public SOAServerPipelineFactory rebuildPipeline() {
        return this;
    }
}

