/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import com.xunlei.netty.httpserver.exception.AntiDosError;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.StringTools;
import com.xunlei.netty.util.ValueUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class AntiDos {
    private static final Logger log = Log.getLogger();
    private int antiDosCount;
    private int antiDosSpanMs;
    private int antiDosWarnCount;
    private ScheduledFuture<?> lastScheduledFuture;
    private ConcurrentHashMap<Object, VisitInfo> visitInfos = new ConcurrentHashMap();

    public static void main(String[] args) throws InterruptedException {
        AntiDos dos = new AntiDos().initSweeper();
        while (true) {
            if (dos.visit(1L)) {
                System.out.println(System.currentTimeMillis() + " - true");
            } else {
                System.err.println(System.currentTimeMillis() + " - false");
            }
            Thread.sleep(300L);
        }
    }

    public AntiDos() {
        this(10, 10);
    }

    public AntiDos(int antiDosCount, int antiDosSpanSec) {
        this.init(antiDosCount, antiDosSpanSec);
    }

    public AntiDos(String conf) {
        List<String> list = StringTools.splitAndTrim(conf, ",");
        if (list.size() != 2) {
            throw new IllegalArgumentException("conf's pattern should be antiDosCount,antiDosSpanSec");
        }
        this.init(ValueUtil.getInteger(list.get(0), -1), ValueUtil.getInteger(list.get(1), -1));
    }

    public int getAntiDosCount() {
        return this.antiDosCount;
    }

    public int getAntiDosSpan() {
        return this.antiDosSpanMs;
    }

    public int getAntiDosWarnCount() {
        return this.antiDosWarnCount;
    }

    public ConcurrentHashMap<Object, VisitInfo> getVisitInfos() {
        return this.visitInfos;
    }

    private void init(int antiDosCount_l, int antiDosSpanSec) {
        if (antiDosCount_l < 1) {
            throw new IllegalArgumentException("antiDosCount must greater than 1");
        }
        if (antiDosSpanSec < 1) {
            throw new IllegalArgumentException("antiDosSpan must greater than 1");
        }
        this.antiDosCount = antiDosCount_l;
        this.antiDosWarnCount = antiDosCount_l * 5;
        this.antiDosSpanMs = antiDosSpanSec * 1000;
    }

    public AntiDos initSweeper() {
        return this.initSweeper(0, null);
    }

    public AntiDos initSweeper(int sweepSecSpan, ScheduledExecutorService sweepScheduler) {
        this.initSweeper(sweepSecSpan, sweepSecSpan, sweepScheduler);
        return this;
    }

    public AntiDos initSweeper(int initialDelay, int sweepSecSpan, ScheduledExecutorService sweepScheduler) {
        ScheduledExecutorService sweepScheduler_l;
        int sweepSecSpan_l = sweepSecSpan < 1 ? 600 : sweepSecSpan;
        int initialDelay_l = initialDelay < 1 ? 600 : initialDelay;
        ScheduledExecutorService scheduledExecutorService = sweepScheduler_l = sweepScheduler == null ? Executors.newScheduledThreadPool(1) : sweepScheduler;
        if (this.lastScheduledFuture != null) {
            this.lastScheduledFuture.cancel(true);
        }
        this.lastScheduledFuture = sweepScheduler_l.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    long now = System.currentTimeMillis();
                    for (Map.Entry e : AntiDos.this.visitInfos.entrySet()) {
                        VisitInfo info = (VisitInfo)e.getValue();
                        if (!info.isStale(now)) continue;
                        AntiDos.this.removeVisitInfo(e.getKey(), info.counter.get());
                    }
                }
                catch (Throwable e) {
                    log.error("", e);
                }
            }
        }, initialDelay_l, sweepSecSpan_l, TimeUnit.SECONDS);
        return this;
    }

    private void removeVisitInfo(Object checkid, int count) {
        if (count >= this.antiDosWarnCount) {
            log.warn("checkid:{} last {} SEC visitCount is {}", new Object[]{checkid, this.antiDosSpanMs, count});
        }
        this.visitInfos.remove(checkid);
    }

    public void setAntiDosCount(int antiDosCount) {
        this.antiDosCount = antiDosCount;
    }

    public void setAntiDosSpan(int antiDosSpanSec) {
        this.antiDosSpanMs = antiDosSpanSec * 1000;
    }

    public void setAntiDosWarnCount(int antiDosWarnCount) {
        this.antiDosWarnCount = antiDosWarnCount;
    }

    public boolean visit(Object checkid) {
        VisitInfo newInfo = new VisitInfo();
        VisitInfo ori = this.visitInfos.putIfAbsent(checkid, newInfo);
        if (ori != null) {
            newInfo = null;
            return ori.visit(checkid);
        }
        newInfo.init();
        return true;
    }

    public boolean visit(Object checkid, int count) {
        VisitInfo newInfo = new VisitInfo();
        VisitInfo ori = this.visitInfos.putIfAbsent(checkid, newInfo);
        if (ori != null) {
            newInfo = null;
            return ori.visit(checkid, count);
        }
        return newInfo.init(count);
    }

    public void visitAndCheck(Object checkid) {
        if (!this.visit(checkid)) {
            throw AntiDosError.INSTANCE;
        }
    }

    public void visitAndCheck(Object checkid, int count) {
        if (!this.visit(checkid, count)) {
            throw AntiDosError.INSTANCE;
        }
    }

    private class VisitInfo {
        private volatile AtomicInteger counter;
        private long createTime;

        private VisitInfo() {
        }

        public void init() {
            AtomicInteger i;
            this.counter = i = new AtomicInteger(1);
            this.createTime = System.currentTimeMillis();
        }

        public boolean init(int count) {
            this.counter = new AtomicInteger(count);
            this.createTime = System.currentTimeMillis();
            return count < AntiDos.this.antiDosCount;
        }

        public boolean isStale() {
            return System.currentTimeMillis() - this.createTime >= (long)AntiDos.this.antiDosSpanMs;
        }

        public boolean isStale(long now) {
            return now - this.createTime >= (long)AntiDos.this.antiDosSpanMs;
        }

        public boolean visit(Object checkid) {
            if (null == this.counter) {
                return true;
            }
            int count = this.counter.incrementAndGet();
            if (this.isStale()) {
                AntiDos.this.removeVisitInfo(checkid, count);
            }
            return count < AntiDos.this.antiDosCount;
        }

        public boolean visit(Object checkid, int count) {
            int c = this.counter.addAndGet(count);
            if (this.isStale()) {
                AntiDos.this.removeVisitInfo(checkid, c);
            }
            return c < AntiDos.this.antiDosCount;
        }
    }
}

