/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.xunlei.netty.util.Log;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.DefaultCookie;
import org.jboss.netty.util.internal.CaseIgnoringComparator;
import org.slf4j.Logger;

public class XLCookieDecoder {
    public static final XLCookieDecoder INSTANCE = new XLCookieDecoder();
    private static final Logger log = Log.getLogger();
    public static final Set<String> RESERVED_NAMES = new TreeSet<String>((Comparator<String>)CaseIgnoringComparator.INSTANCE);

    public static String stripQuote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            try {
                return value.substring(1, value.length() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public static Map<String, Cookie> decode(String cookieString, Map<String, Cookie> map) {
        StringTokenizer tok = new StringTokenizer(cookieString, ";", false);
        while (tok.hasMoreTokens()) {
            String name;
            String token = tok.nextToken();
            int i = token.indexOf("=");
            if (i <= -1 || RESERVED_NAMES.contains(name = token.substring(0, i).trim())) continue;
            String value = XLCookieDecoder.stripQuote(token.substring(i + 1).trim());
            try {
                map.put(name, (Cookie)new DefaultCookie(name, value));
            }
            catch (Exception e) {
                log.warn("new DefaultCookie fail,name:{},value:{}", new Object[]{name, value});
            }
        }
        return map;
    }

    static {
        RESERVED_NAMES.add("$Domain");
        RESERVED_NAMES.add("$Path");
        RESERVED_NAMES.add("$Comment");
        RESERVED_NAMES.add("$CommentURL");
        RESERVED_NAMES.add("$Discard");
        RESERVED_NAMES.add("$Port");
        RESERVED_NAMES.add("$Max-Age");
        RESERVED_NAMES.add("$Expires");
        RESERVED_NAMES.add("$Version");
        RESERVED_NAMES.add("$Secure");
        RESERVED_NAMES.add("$HTTPOnly");
    }
}

