/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.xunlei.netty.httpserver.cmd.CmdMappers;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.ClosedChannelError;
import com.xunlei.netty.httpserver.exception.ProcessTimeoutError;
import com.xunlei.netty.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;

public class XLContextAttachment
implements ChannelFutureListener {
    private static final Logger log = Log.getLogger();
    private XLHttpRequest request;
    private XLHttpResponse response;
    private ChannelHandlerContext channelHandlerContext;
    private CmdMappers.CmdMeta cmdMeta;
    private volatile Thread processThread;
    private List<Throwable> throwables;
    private boolean closeAfterOperationComplete = true;
    private int respOperationCompleteCount = 0;
    private static final String HTTP_HEADER_KEEP_ALIVE = "Keep-Alive";

    public void registerThrowable(Throwable ex) {
        if (this.throwables == null) {
            this.throwables = new ArrayList<Throwable>(1);
        }
        this.throwables.add(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkChannelOrThread() {
        boolean shutdown = false;
        try {
            boolean bl = shutdown = !this.channelHandlerContext.getChannel().isOpen();
            if (shutdown) {
                throw ClosedChannelError.INSTANCE;
            }
            if (this.processThread != null && (shutdown = this.processThread.isInterrupted())) {
                throw ProcessTimeoutError.INSTANCE;
            }
        }
        finally {
            if (shutdown) {
                // empty if block
            }
        }
    }

    public synchronized void interrupt(StringBuilder info) {
        if (this.processThread != null) {
            this.processThread.interrupt();
            if (info != null) {
                info.append("[processThread]").append(this.processThread.getName());
            }
        }
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (this.respOperationCompleteCount > 0) {
            sb.append("[").append(this.respOperationCompleteCount).append("]");
        }
        sb.append(this.cmdMeta);
        sb.append(this.request == null ? "" : "-" + Integer.toHexString(((Object)((Object)this.request)).hashCode()));
        sb.append(this.channelHandlerContext.getChannel().getRemoteAddress());
        sb.append("/");
        return sb.toString();
    }

    public String toString() {
        return this.getName();
    }

    public XLContextAttachment(ChannelHandlerContext channelHandlerContext) {
        this.channelHandlerContext = channelHandlerContext;
    }

    public void setRequest(XLHttpRequest request) {
        this.request = request;
    }

    public XLHttpRequest getRequest() {
        return this.request;
    }

    public void setResponse(XLHttpResponse response) {
        this.response = response;
    }

    public XLHttpResponse getResponse() {
        return this.response;
    }

    public CmdMappers.CmdMeta getCmdMeta() {
        return this.cmdMeta;
    }

    public void setCmdMeta(CmdMappers.CmdMeta cmdMeta) {
        this.cmdMeta = cmdMeta;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }

    public List<Throwable> getThrowables() {
        return this.throwables;
    }

    public Thread getProcessThread() {
        return this.processThread;
    }

    public void registerProcessThread() {
        this.processThread = Thread.currentThread();
    }

    public void unregisterProcessThread() {
        this.processThread = null;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        ++this.respOperationCompleteCount;
        if (this.closeAfterOperationComplete) {
            future.getChannel().close();
        }
        if (this.request != null) {
            this.request.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setKeepAliveHeader() {
        int timeout = this.response.getKeepAliveTimeout();
        boolean close = true;
        try {
            close = timeout == -1 ? "close".equalsIgnoreCase(this.request.getHeader("Connection")) || this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !"keep-alive".equalsIgnoreCase(this.request.getHeader("Connection")) : timeout <= 0;
        }
        finally {
            this.response.setHeader("Content-Length", String.valueOf(this.response.getContentLength()));
            if (close) {
                this.response.setHeader("Connection", "close");
            } else if (timeout != -1) {
                this.response.setHeader("Connection", "keep-alive");
                this.response.setHeader(HTTP_HEADER_KEEP_ALIVE, "timeout=" + timeout);
            }
        }
        this.closeAfterOperationComplete = close;
        return close;
    }
}

