/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.concurrent.ConcurrentHashSet;
import com.xunlei.netty.util.concurrent.ConcurrentUtil;
import com.xunlei.netty.util.spring.Config;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeoutInterrupter {
    private static TimeoutInterrupter INSTANCE;
    @Autowired
    protected NettyServerConfig config;
    private static final Logger log;
    private Runnable _defaultInterrupter = new Runnable(){

        private void close(XLContextAttachment attach, String tips) {
            Channel channel = attach.getChannelHandlerContext().getChannel();
            channel.close();
            TimeoutInterrupter.this.sweepedChannelNum++;
            log.warn("close {} attach:{}", (Object)tips, (Object)attach);
        }

        @Override
        public void run() {
            try {
                Iterator it = TimeoutInterrupter.this.liveAttach.iterator();
                while (it.hasNext()) {
                    XLContextAttachment attach = (XLContextAttachment)it.next();
                    Channel channel = attach.getChannelHandlerContext().getChannel();
                    if (!channel.isConnected()) {
                        it.remove();
                        log.debug("removed closed channel {}", (Object)channel);
                        continue;
                    }
                    long read = 0L;
                    long write = 0L;
                    long all = Math.max(read, write);
                    int allTimeout = TimeoutInterrupter.this.allIdleTimeSeconds;
                    long now = System.currentTimeMillis();
                    XLHttpResponse response = attach.getResponse();
                    if (response == null) {
                        if (TimeoutInterrupter.this.readerIdleTimeSeconds > 0 && now - read > (long)(TimeoutInterrupter.this.readerIdleTimeSeconds * 1000)) {
                            this.close(attach, "readIdle-" + TimeoutInterrupter.this.readerIdleTimeSeconds);
                            continue;
                        }
                        if (TimeoutInterrupter.this.writerIdleTimeSeconds > 0 && now - write > (long)(TimeoutInterrupter.this.writerIdleTimeSeconds * 1000)) {
                            this.close(attach, "writeIdle-" + TimeoutInterrupter.this.writerIdleTimeSeconds);
                            continue;
                        }
                    } else {
                        int keepAliveTimeout = response.getKeepAliveTimeout();
                        allTimeout = Math.max(TimeoutInterrupter.this.allIdleTimeSeconds, keepAliveTimeout);
                    }
                    if (allTimeout <= 0 || now - all <= (long)(allTimeout * 1000)) continue;
                    this.close(attach, "allIdle-" + allTimeout);
                }
            }
            catch (Throwable e) {
                log.error("", e);
            }
        }
    };
    public final AttachRegister _defaultRegister = new AttachRegister(){

        @Override
        public void registerAttach(XLContextAttachment attach) {
            TimeoutInterrupter.this.liveAttach.add(attach);
        }

        @Override
        public void unregisterAttach(XLContextAttachment attach) {
            if (!TimeoutInterrupter.this.liveAttach.remove(attach)) {
                // empty if block
            }
        }
    };
    public final AttachRegister _nopRegister = new AttachRegister(){

        @Override
        public void registerAttach(XLContextAttachment attach) {
        }

        @Override
        public void unregisterAttach(XLContextAttachment attach) {
        }
    };
    @Config(resetable=true)
    public volatile int allIdleTimeSeconds = 0;
    private AttachRegister attachRegister = this._nopRegister;
    private final Set<XLContextAttachment> liveAttach = new ConcurrentHashSet<XLContextAttachment>();
    @Config(resetable=true)
    public volatile int readerIdleTimeSeconds = 0;
    private ScheduledFuture<?> scheduledFuture;
    private volatile long sweepedChannelNum;
    @Config(resetable=true)
    private int sweepFrequencySeconds = 1;
    private Boolean threadInterrupterEnable;
    @Config(resetable=true)
    public volatile int writerIdleTimeSeconds = 0;

    private TimeoutInterrupter() {
        INSTANCE = this;
    }

    public static TimeoutInterrupter getInstance() {
        return INSTANCE;
    }

    public int currentChannelsNum() {
        return this.liveAttach.size();
    }

    public AttachRegister getAttachRegister() {
        return this.attachRegister;
    }

    public boolean isEnable() {
        return this.threadInterrupterEnable != false || this.readerIdleTimeSeconds > 0 || this.allIdleTimeSeconds > 0 || this.writerIdleTimeSeconds > 0;
    }

    private synchronized boolean reset() {
        if (this.threadInterrupterEnable == null) {
            return false;
        }
        boolean result = false;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        if (result) {
            this.attachRegister = this._defaultRegister;
            log.warn("TimeoutInterrupter      ON,ioIdle:{},{},{},cmdTimeout:{}", new Object[]{this.readerIdleTimeSeconds, this.writerIdleTimeSeconds, this.allIdleTimeSeconds, this.threadInterrupterEnable});
            this.scheduledFuture = ConcurrentUtil.getDaemonExecutor().scheduleWithFixedDelay(this._defaultInterrupter, this.sweepFrequencySeconds, this.sweepFrequencySeconds, TimeUnit.SECONDS);
        } else {
            this.attachRegister = this._nopRegister;
            this.liveAttach.clear();
            log.warn("TimeoutInterrupter      OFF");
        }
        return result;
    }

    public void setThreadInterrupterEnable(boolean threadInterrupterEnable) {
        int ori = this.hashCode();
        this.threadInterrupterEnable = threadInterrupterEnable;
        int now = this.hashCode();
        if (ori != now) {
            this.reset();
        }
    }

    public long sweepedChannelNum() {
        return this.sweepedChannelNum;
    }

    public synchronized void sweepedChannelNumIncr(int count) {
        this.sweepedChannelNum += (long)count;
    }

    public int getAllIdleTimeSeconds() {
        return this.allIdleTimeSeconds;
    }

    public int getReaderIdleTimeSeconds() {
        return this.readerIdleTimeSeconds;
    }

    public long getSweepedChannelNum() {
        return this.sweepedChannelNum;
    }

    public int getSweepFrequencySeconds() {
        return this.sweepFrequencySeconds;
    }

    public int getWriterIdleTimeSeconds() {
        return this.writerIdleTimeSeconds;
    }

    public void setAllIdleTimeSeconds(int allIdleTimeSeconds) {
        int ori = this.hashCode();
        this.allIdleTimeSeconds = allIdleTimeSeconds;
        int now = this.hashCode();
        if (ori != now) {
            this.reset();
        }
    }

    public void setReaderIdleTimeSeconds(int readerIdleTimeSeconds) {
        int ori = this.hashCode();
        this.readerIdleTimeSeconds = readerIdleTimeSeconds;
        int now = this.hashCode();
        if (ori != now) {
            this.reset();
        }
    }

    public void setWriterIdleTimeSeconds(int writerIdleTimeSeconds) {
        int ori = this.hashCode();
        this.writerIdleTimeSeconds = writerIdleTimeSeconds;
        int now = this.hashCode();
        if (ori != now) {
            this.reset();
        }
    }

    public void setSweepFrequencySeconds(int sweepFrequency) {
        int ori = this.hashCode();
        this.sweepFrequencySeconds = sweepFrequency;
        int now = this.hashCode();
        if (ori != now) {
            this.reset();
        }
    }

    public Set<XLContextAttachment> getLiveAttach() {
        return this.liveAttach;
    }

    public void removeAttach(XLContextAttachment attach) {
        this.liveAttach.remove(attach);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.allIdleTimeSeconds;
        result = 31 * result + this.readerIdleTimeSeconds;
        result = 31 * result + this.sweepFrequencySeconds;
        result = 31 * result + this.writerIdleTimeSeconds;
        result = 31 * result + (this.threadInterrupterEnable == null ? 0 : this.threadInterrupterEnable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeoutInterrupter other = (TimeoutInterrupter)obj;
        if (this.allIdleTimeSeconds != other.allIdleTimeSeconds) {
            return false;
        }
        if (this.readerIdleTimeSeconds != other.readerIdleTimeSeconds) {
            return false;
        }
        if (this.sweepFrequencySeconds != other.sweepFrequencySeconds) {
            return false;
        }
        return this.writerIdleTimeSeconds == other.writerIdleTimeSeconds;
    }

    static {
        log = Log.getLogger();
    }

    public static interface AttachRegister {
        public void registerAttach(XLContextAttachment var1);

        public void unregisterAttach(XLContextAttachment var1);
    }
}

