/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.xunlei.netty.httpserver.cmd.CmdMappers;
import com.xunlei.netty.httpserver.component.AbstractPageDispatcher;
import com.xunlei.netty.httpserver.component.TimeoutInterrupter;
import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NetUtil;
import com.xunlei.netty.util.NettyServerConfig;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BasePageDispatcher
extends AbstractPageDispatcher {
    private static final Logger log = Log.getLogger();
    @Autowired
    protected CmdMappers cmdMappers;
    @Autowired
    protected NettyServerConfig config;
    @Autowired
    private TimeoutInterrupter timeoutInterrupter;

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        XLContextAttachment attach = this.getAttach(ctx);
        if (null != attach) {
            this.timeoutInterrupter.getAttachRegister().unregisterAttach(attach);
            attach.interrupt(null);
            XLHttpRequest request = attach.getRequest();
            if (request != null) {
                request.clean();
            }
        }
        super.channelClosed(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        XLContextAttachment attach = this.getAttach(ctx);
        this.timeoutInterrupter.getAttachRegister().registerAttach(attach);
        super.channelConnected(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        NetUtil.exceptionCaught(ctx, e);
        ctx.getChannel().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        block8: {
            XLContextAttachment attach = this.getAttach(ctx);
            Object obj = messageEvent.getMessage();
            try {
                if (obj instanceof XLHttpRequest) {
                    XLHttpRequest request = (XLHttpRequest)((Object)obj);
                    request.setRemoteAddress(messageEvent.getRemoteAddress());
                    request.setLocalAddress(messageEvent.getChannel().getLocalAddress());
                    XLHttpResponse response = new XLHttpResponse(attach);
                    attach.setRequest(request);
                    attach.setResponse(response);
                    if (request.isChunked()) {
                    } else {
                        this.dispatch(attach);
                    }
                    break block8;
                }
                if (obj instanceof HttpChunk) {
                    XLHttpRequest request = attach.getRequest();
                    HttpChunk httpChunk = (HttpChunk)obj;
                    request.offerChunk(httpChunk);
                    if (httpChunk.isLast()) {
                        this.dispatch(attach);
                    }
                    break block8;
                }
                throw new RuntimeException("cant resolve message:" + obj);
            }
            finally {
                ctx.sendUpstream((ChannelEvent)messageEvent);
            }
        }
    }

    protected abstract void dispatch(XLContextAttachment var1) throws Exception;

    @Override
    public void init() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XLContextAttachment getAttach(ChannelHandlerContext ctx) {
        XLContextAttachment attach = (XLContextAttachment)ctx.getAttachment();
        if (attach == null) {
            ChannelHandlerContext channelHandlerContext = ctx;
            synchronized (channelHandlerContext) {
                attach = (XLContextAttachment)ctx.getAttachment();
                if (attach == null) {
                    attach = new XLContextAttachment(ctx);
                    ctx.setAttachment((Object)attach);
                }
            }
        }
        return attach;
    }
}

