/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd.common;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.xunlei.netty.cache.JRedisProxy;
import com.xunlei.netty.httpserver.cmd.BaseStatCmd;
import com.xunlei.netty.httpserver.cmd.annotation.CmdAdmin;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.util.HumanReadableUtil;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.SystemInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.sql.SQLException;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPool;

@Service
public class StatCmd
extends BaseStatCmd {
    private static final Logger log = Log.getLogger();
    @Autowired
    private NettyServerConfig config;

    @Override
    @CmdAdmin
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder();
        tmp.append(this.getSytemInfo());
        return tmp.toString();
    }

    private String getSytemInfo() {
        JedisPool jedisPool;
        StringBuilder tmp = new StringBuilder();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        tmp.append("runtimeMXBean\n");
        tmp.append("\u542f\u52a8\u65f6\u95f4:\t\t").append(SystemInfo.getServerStartupTime()).append("\n");
        tmp.append("\u5df2\u8fd0\u884c:\t\t\t").append(HumanReadableUtil.timeSpan(runtimeMXBean.getUptime())).append("\n");
        tmp.append("\u8fdb\u7a0b:\t\t\t").append(runtimeMXBean.getName()).append("\n");
        tmp.append("\u540d\u79f0:\t\t\t").append(SystemInfo.LAUNCHER_NAME).append("\n");
        tmp.append("\u865a\u62df\u673a:\t\t\t").append(runtimeMXBean.getVmName()).append(" ").append(runtimeMXBean.getVmVersion()).append("\n");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        tmp.append("\n");
        tmp.append("ThreadMXBean\n");
        tmp.append("\u5f53\u524d\u7ebf\u7a0b\u6570:\t\t").append(threadMXBean.getThreadCount()).append("\n");
        tmp.append("\u540e\u53f0\u7ebf\u7a0b\u6570:\t\t").append(threadMXBean.getDaemonThreadCount()).append("\n");
        tmp.append("\u5cf0\u503c\u7ebf\u7a0b\u6570:\t\t").append(threadMXBean.getPeakThreadCount()).append("\n");
        tmp.append("\u5df2\u542f\u52a8\u7ebf\u7a0b\u6570:\t\t").append(threadMXBean.getTotalStartedThreadCount()).append("\n");
        tmp.append("\n");
        OrderedMemoryAwareThreadPoolExecutor pipelineExecutor = this.config.getPipelineExecutor();
        tmp.append("\n");
        tmp.append("Netty\u4e1a\u52a1\u7ebf\u7a0b\u6c60[PipelineExecutor]\n");
        tmp.append("ActiveCount:\t\t").append(pipelineExecutor.getActiveCount()).append("\n");
        tmp.append("CompletedTaskCount:\t").append(pipelineExecutor.getCompletedTaskCount()).append("\n");
        tmp.append("CorePoolSize:\t\t").append(pipelineExecutor.getCorePoolSize()).append("\n");
        tmp.append("LargestPoolSize:\t").append(pipelineExecutor.getLargestPoolSize()).append("\n");
        tmp.append("MaximumPoolSize:\t").append(pipelineExecutor.getMaximumPoolSize()).append("\n");
        tmp.append("PoolSize:\t\t").append(pipelineExecutor.getPoolSize()).append("\n");
        tmp.append("MaxChannelMemorySize:\t").append(pipelineExecutor.getMaxChannelMemorySize()).append("\n");
        tmp.append("MaxTotalMemorySize:\t").append(pipelineExecutor.getMaxTotalMemorySize()).append("\n");
        int queueCount = 0;
        if (pipelineExecutor.getQueue() != null && pipelineExecutor.getQueue().size() > 0) {
            queueCount = pipelineExecutor.getQueue().size();
        }
        tmp.append("QueueCount:\t\t").append(queueCount).append("\n");
        tmp.append("TaskCount:\t\t").append(pipelineExecutor.getTaskCount()).append("\n");
        tmp.append("\n");
        if (JRedisProxy.getInstance() != null && (jedisPool = JRedisProxy.getInstance().getJedisPool()) != null) {
            tmp.append("\n");
            tmp.append("Redis\u7ebf\u7a0b\u6c60[JedisPool]\n");
            tmp.append("\u6700\u5927\u8fde\u63a5\u6570[JRedisProxy.MaxTotal]:\t\t").append(JRedisProxy.getInstance().getMaxTotal()).append("\n");
            tmp.append("\u6700\u5927\u7a7a\u95f2\u8fde\u63a5\u6570[JRedisProxy.MaxIdle]:\t\t").append(JRedisProxy.getInstance().getMaxIdle()).append("\n");
            tmp.append("\u6700\u5927\u7b49\u5f85\u6beb\u79d2\u6570[JRedisProxy.MaxWaitMillis]:\t").append(JRedisProxy.getInstance().getMaxWaitMillis()).append("\n");
            tmp.append("NumActive:\t\t\t\t\t").append(jedisPool.getNumActive()).append("\n");
            tmp.append("NumIdle:\t\t\t\t\t").append(jedisPool.getNumIdle()).append("\n");
            tmp.append("NumWaiters:\t\t\t\t\t").append(jedisPool.getNumWaiters()).append("\n");
            tmp.append("MaxBorrowWaitTimeMillis:\t\t\t").append(jedisPool.getMaxBorrowWaitTimeMillis()).append("\n");
            tmp.append("MeanBorrowWaitTimeMillis:\t\t\t").append(jedisPool.getMeanBorrowWaitTimeMillis()).append("\n");
            tmp.append("\n");
        }
        if (this.config.getC3p0ComboPool() != null && this.config.getC3p0ComboPool().size() > 0) {
            tmp.append("\n");
            for (ComboPooledDataSource c3p0Pool : this.config.getC3p0ComboPool()) {
                tmp.append("C3p0\u7ebf\u7a0b\u6c60[C3p0ComboPool]---").append(c3p0Pool.getJdbcUrl()).append("\n");
                tmp.append("\u6700\u5927\u8fde\u63a5\u6570[C3p0ComboPool.MaxPoolSize]:\t\t\t\t").append(c3p0Pool.getMaxPoolSize()).append("\n");
                tmp.append("\u6700\u5c0f\u8fde\u63a5\u6570[C3p0ComboPool.MinPoolSize]:\t\t\t\t").append(c3p0Pool.getMinPoolSize()).append("\n");
                tmp.append("\u521d\u59cb\u5316\u65f6\u8fde\u63a5\u6570[C3p0ComboPool.InitialPoolSize]:\t\t\t").append(c3p0Pool.getInitialPoolSize()).append("\n");
                tmp.append("\u7b49\u5f85\u83b7\u53d6\u65b0\u8fde\u63a5\u65f6\u95f4(ms)[C3p0ComboPool.CheckoutTimeout]:\t\t").append(c3p0Pool.getCheckoutTimeout()).append("\n");
                tmp.append("\u6700\u5927\u7a7a\u95f2\u65f6\u95f4(s)[C3p0ComboPool.MaxIdleTime]:\t\t\t").append(c3p0Pool.getMaxIdleTime()).append("\n");
                tmp.append("\u540c\u65f6\u83b7\u53d6\u7684\u8fde\u63a5\u6570[C3p0ComboPool.AcquireIncrement]:\t\t").append(c3p0Pool.getAcquireIncrement()).append("\n");
                try {
                    tmp.append("\u603b\u8fde\u63a5\u6570[C3p0ComboPool.NumConnections]:\t\t\t\t").append(c3p0Pool.getNumConnections()).append("\n");
                    tmp.append("\u5fd9\u8fde\u63a5\u6570[C3p0ComboPool.NumBusyConnections]:\t\t\t").append(c3p0Pool.getNumBusyConnections()).append("\n");
                    tmp.append("\u7a7a\u95f2\u8fde\u63a5\u6570[C3p0ComboPool.NumIdleConnections]:\t\t\t").append(c3p0Pool.getNumIdleConnections()).append("\n");
                }
                catch (SQLException e) {
                    log.error("\u83b7\u53d6C3p0\u8fde\u63a5\u6c60[StatCmd.getSytemInfo]\u5f02\u5e38", (Throwable)e);
                }
                tmp.append("\n");
            }
            tmp.append("\n");
        }
        SystemInfo.getMemoryInfo(tmp);
        SystemInfo.getGarbageCollectorInfo(tmp);
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        tmp.append("\n");
        tmp.append("operatingSystemMXBean\n");
        tmp.append("\u64cd\u4f5c\u7cfb\u7edf:\t\t").append(operatingSystemMXBean.getName()).append(" ").append(operatingSystemMXBean.getVersion()).append("\n");
        tmp.append("\u4f53\u7cfb\u7ed3\u6784:\t\t").append(operatingSystemMXBean.getArch()).append("\n");
        tmp.append("\u5904\u7406\u5668\u4e2a\u6570:\t\t").append(operatingSystemMXBean.getAvailableProcessors()).append("\n");
        return tmp.toString();
    }
}

