/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd.common;

import com.xunlei.netty.httpserver.cmd.BaseStatCmd;
import com.xunlei.netty.httpserver.cmd.annotation.CmdAdmin;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.soaserver.component.SOAServiceBase;
import com.xunlei.netty.soaserver.component.SOAServiceCmdFactory;
import com.xunlei.netty.util.HtmlUtil;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.spring.ConfigBeanPostProcessor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SOAServerCmd
extends BaseStatCmd {
    private static final Logger log = Log.getLogger();
    @Autowired
    private ConfigBeanPostProcessor configProcessor;

    @CmdAdmin
    public Object soaServiceAPIList(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        response.setInnerContentType(XLHttpResponse.ContentType.html);
        ArrayList<Map<String, String>> tableData = new ArrayList<Map<String, String>>();
        String tmp = "";
        LinkedHashMap<String, String> mapData = new LinkedHashMap<String, String>();
        List<SOAServiceCmdFactory> soaAPIList = SOAServiceCmdFactory.getSoaServiceCmdFactoryList();
        if (soaAPIList != null && soaAPIList.size() > 0) {
            for (SOAServiceCmdFactory soaServiceCmdFactory : soaAPIList) {
                Field[] fieldArray;
                Class<?> serviceBaseClass;
                for (serviceBaseClass = soaServiceCmdFactory.getClass(); serviceBaseClass != null && serviceBaseClass != SOAServiceBase.class; serviceBaseClass = serviceBaseClass.getSuperclass()) {
                }
                if (serviceBaseClass == null || (fieldArray = serviceBaseClass.getDeclaredFields()) == null || fieldArray.length <= 0) continue;
                for (Field field : fieldArray) {
                    if (field.getName().equals("log") || field.getName().equals("appName")) continue;
                    field.setAccessible(true);
                    mapData = new LinkedHashMap();
                    mapData.put("ConfigKey", String.format("%s\u670d\u52a1[%s]", soaServiceCmdFactory.getAppName(), field.getName()));
                    String appName = HtmlUtil.getInputHidden("appName", soaServiceCmdFactory.getAppName());
                    String fieldName = HtmlUtil.getInputHidden("fieldName", field.getName());
                    String fieldValue = HtmlUtil.getInputText("fieldValue", field.get(soaServiceCmdFactory) + "");
                    String configValueText = HtmlUtil.getHtmlForm(appName + fieldName + fieldValue, "/sOAServer/updateSOAServiceAPI");
                    mapData.put("ConfigValue", configValueText);
                    tableData.add(mapData);
                }
            }
        }
        if (tableData.size() == 0) {
            mapData = new LinkedHashMap();
            mapData.put("ConfigKey", "\u5f53\u524d\u8fd8\u672a\u6709\u503c");
            mapData.put("ConfigValue", "\u5f53\u524d\u8fd8\u672a\u6709\u503c");
            tableData.add(mapData);
        }
        tmp = HtmlUtil.getHtmlTable(tableData);
        return tmp;
    }

    @CmdAdmin
    public Object updateSOAServiceAPI(XLHttpRequest request, XLHttpResponse response) throws Exception {
        String refererUrl;
        this.init(request, response);
        StringBuilder tmp = new StringBuilder("update SOA Service API...\n");
        String appName = request.getParameter("appName", "");
        String fieldName = request.getParameter("fieldName", "");
        String fieldValue = request.getParameter("fieldValue", "");
        if (StringUtils.isBlank((String)appName)) {
            throw new Exception("appName\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)fieldName)) {
            throw new Exception("fieldName\u4e3a\u7a7a");
        }
        List<SOAServiceCmdFactory> soaAPIList = SOAServiceCmdFactory.getSoaServiceCmdFactoryList();
        if (soaAPIList != null && soaAPIList.size() > 0) {
            Object soaAPIService = null;
            for (SOAServiceCmdFactory soaServiceCmdFactory : soaAPIList) {
                if (!appName.equals(soaServiceCmdFactory.getAppName())) continue;
                soaAPIService = soaServiceCmdFactory;
                break;
            }
            if (soaAPIService != null) {
                Field field;
                Class<?> serviceBaseClass;
                for (serviceBaseClass = soaAPIService.getClass(); serviceBaseClass != null && serviceBaseClass != SOAServiceBase.class; serviceBaseClass = serviceBaseClass.getSuperclass()) {
                }
                if (serviceBaseClass != null && (field = serviceBaseClass.getDeclaredField(fieldName)) != null) {
                    field.setAccessible(true);
                    String oriValue = field.get(soaAPIService) + "";
                    SimpleTypeConverter typeConverter = new SimpleTypeConverter();
                    Object value = typeConverter.convertIfNecessary((Object)fieldValue, field.getType());
                    field.set(soaAPIService, value);
                    this.configProcessor.appendResetHistory("SOAServiceAPI." + appName, fieldName, oriValue, fieldValue);
                }
            }
        }
        if (StringUtils.isNotBlank((String)(refererUrl = request.getHeader("Referer")))) {
            response.redirect(refererUrl);
        }
        return tmp.toString();
    }
}

