/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd;

import com.xunlei.netty.httpserver.cmd.BaseCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.cmd.annotation.CmdAdmin;
import com.xunlei.netty.httpserver.component.TimeoutInterrupter;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.util.Log;
import com.xunlei.netty.util.NettyServerConfig;
import com.xunlei.netty.util.spring.BeanUtil;
import com.xunlei.netty.util.spring.SpringBootstrap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CmdMappers {
    @Autowired
    private TimeoutInterrupter timeoutInterrupter;
    private static final Logger log = Log.getLogger();
    private Map<String, CmdMeta> cmdAllMap = new LinkedHashMap<String, CmdMeta>();
    private final Map<CmdMeta, CmdMeta> cmdMetaUnite = new HashMap<CmdMeta, CmdMeta>();
    private List<BaseCmd> cmds;
    @Autowired
    private NettyServerConfig config;
    private int globalTimeout = 0;

    private static String sanitizePath(String path) {
        int len;
        if (StringUtils.isNotBlank((String)path) && (len = (path = path.trim()).length()) > 1 && path.lastIndexOf(47) == len - 1) {
            path = path.substring(0, len - 1);
        }
        return path;
    }

    public Map<String, CmdMeta> getCmdAllMap() {
        return this.cmdAllMap;
    }

    private String _lower(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    private BaseCmd getCmd(String name) {
        Object obj = BeanUtil.getTypedBean(name);
        if (obj instanceof BaseCmd) {
            Class<?> clazz = obj.getClass();
            if (clazz.getAnnotation(Deprecated.class) != null) {
                return null;
            }
            return (BaseCmd)obj;
        }
        return null;
    }

    public CmdMeta getCmdMeta(String path) throws Exception {
        path = CmdMappers.sanitizePath(path);
        CmdMeta meta = this.cmdAllMap.get(path);
        return meta;
    }

    private String getCmdName(BaseCmd cmd) {
        String cmdSuffix = this.config.getCmdSuffix();
        String cmdName = this._lower(cmd.getClass().getSimpleName());
        int idx = cmdName.indexOf(36);
        if (idx > 0) {
            cmdName = cmdName.substring(0, idx);
        }
        if (cmdName.endsWith(cmdSuffix)) {
            cmdName = cmdName.substring(0, cmdName.length() - cmdSuffix.length());
        }
        return cmdName;
    }

    private List<BaseCmd> getCmds() {
        if (this.cmds == null) {
            this.cmds = new ArrayList<BaseCmd>();
            for (String name : SpringBootstrap.getContext().getBeanDefinitionNames()) {
                BaseCmd cmd = this.getCmd(name);
                if (cmd == null) continue;
                this.cmds.add(cmd);
            }
        }
        return this.cmds;
    }

    public int getCmdMetaTimeout(CmdMeta cmd) {
        int defaultTimeout = this.globalTimeout;
        return defaultTimeout;
    }

    public Map<String, CmdMeta> initAutoMap() throws Exception {
        LinkedHashMap<String, CmdMeta> tmp_auto = new LinkedHashMap<String, CmdMeta>();
        String cmdDefaultMethod = this.config.getCmdDefaultMethod();
        for (BaseCmd cmd : this.getCmds()) {
            Method[] mehods;
            String cmdName = this.getCmdName(cmd);
            Class<?> clazz = cmd.getClass();
            for (Method method : mehods = clazz.getDeclaredMethods()) {
                String url;
                if (!this.isCmdMethod(cmd, method)) continue;
                String methodName = method.getName();
                CmdMapper cmdMapperForMethod = method.getAnnotation(CmdMapper.class);
                CmdAdmin cmdAdminForMethod = method.getAnnotation(CmdAdmin.class);
                if (!methodName.equals(cmdDefaultMethod) && cmdMapperForMethod == null && cmdAdminForMethod == null) continue;
                CmdMeta meta = this.newCmdMeta(cmd, method);
                String methodUrl = MessageFormat.format("/{0}/{1}", cmdName, methodName);
                if (methodName.equals(cmdDefaultMethod)) {
                    methodUrl = MessageFormat.format("/{0}", cmdName);
                }
                if (cmdMapperForMethod != null && cmdMapperForMethod.value() != null && cmdMapperForMethod.value().length > 0 && StringUtils.isNotBlank((String)(url = cmdMapperForMethod.value()[0]))) {
                    methodUrl = CmdMappers.sanitizePath(url);
                }
                if (tmp_auto.containsKey(methodUrl)) {
                    throw new Exception("Duplicate address Url:" + methodUrl);
                }
                tmp_auto.put(methodUrl, meta);
            }
        }
        this.cmdAllMap.putAll(tmp_auto);
        log.debug("Netty\u670d\u52a1.Url\u6620\u5c04.{}", tmp_auto);
        return tmp_auto;
    }

    private boolean isCmdMethod(BaseCmd cmd, Method method) {
        if (method.getAnnotation(Deprecated.class) != null) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        Class<?>[] pts = method.getParameterTypes();
        if (pts.length != 2) {
            return false;
        }
        return pts[0].isAssignableFrom(XLHttpRequest.class) && pts[1].isAssignableFrom(XLHttpResponse.class);
    }

    private CmdMeta newCmdMeta(BaseCmd cmd, Method method) {
        CmdMeta tmp = new CmdMeta(cmd, method);
        CmdMeta ori = this.cmdMetaUnite.get(tmp);
        if (ori == null) {
            this.cmdMetaUnite.put(tmp, tmp);
            return tmp;
        }
        return ori;
    }

    public void resetCmdConfig() {
        boolean damonScannerEnable = false;
        for (CmdMeta meta : this.cmdMetaUnite.keySet()) {
            meta.timeout = this.getCmdMetaTimeout(meta);
            if (meta.getTimeout() <= 0) continue;
            damonScannerEnable = true;
        }
        this.timeoutInterrupter.setThreadInterrupterEnable(damonScannerEnable);
        log.debug("Netty\u670d\u52a1.\u91cd\u7f6eCMD\u914d\u7f6e,\u540e\u53f0\u626b\u63cf\u5668\uff0c\u8d85\u65f6\u529f\u80fd\u662f\u5426\u542f\u52a8.damonScannerEnable=" + damonScannerEnable);
    }

    public static class CmdMeta {
        private BaseCmd cmd;
        private Method method;
        private String baseName;
        private String name;
        private boolean isAdmin = false;
        private int timeout;

        public CmdMeta(BaseCmd cmd, Method method) {
            this.cmd = cmd;
            this.method = method;
            this.baseName = cmd.getClass().getSimpleName() + ".*";
            this.name = cmd.getClass().getSimpleName() + "." + method.getName();
            if (method.getAnnotation(CmdAdmin.class) != null) {
                this.isAdmin = true;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CmdMeta other = (CmdMeta)obj;
            if (this.cmd == null ? other.cmd != null : !this.cmd.equals(other.cmd)) {
                return false;
            }
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }

        public BaseCmd getCmd() {
            return this.cmd;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean isAdmin() {
            return this.isAdmin;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cmd == null ? 0 : this.cmd.hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        public boolean isDisable() {
            return this.timeout < 0;
        }

        public String toString() {
            return this.name;
        }

        public String getCmdDescription() {
            return this.method.toGenericString();
        }
    }
}

