/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.grpcserver.interceptor;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import com.xunlei.netty.util.GRPCServerHelper;
import com.xunlei.netty.util.Log;
import com.xunlei.niux.common.util.IPUtil;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class CatClientInterceptor
implements ClientInterceptor {
    private static final Logger log = Log.getLogger();

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        long connectionTimeout = (Long)callOptions.getOption(GRPCServerHelper.COKey_ConnectionTimeout);
        if (connectionTimeout > 0L) {
            callOptions = callOptions.withDeadlineAfter(connectionTimeout, TimeUnit.MILLISECONDS);
        }
        String fullMethodName = method.getFullMethodName();
        String authority = next.authority();
        final boolean isAsyncInterface = (Boolean)callOptions.getOption(GRPCServerHelper.COKey_IsAsyncInterface);
        final Transaction t = Cat.newTransaction((String)"PigeonCall", (String)fullMethodName);
        Cat.logEvent((String)"PigeonCall.app", (String)authority);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                if (headers != null) {
                    MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
                    String childId = Cat.createMessageId();
                    Cat.logEvent((String)"RemoteCall", (String)"", (String)"0", (String)childId);
                    String rootMessageId = tree.getRootMessageId();
                    String messageId = tree.getMessageId();
                    if (messageId == null) {
                        messageId = Cat.createMessageId();
                        tree.setMessageId(messageId);
                    }
                    if (rootMessageId == null) {
                        rootMessageId = messageId;
                    }
                    headers.put(GRPCServerHelper.MDKey_ClientIP, (Object)(IPUtil.getLocalHostAddress() + ""));
                    headers.put(GRPCServerHelper.MDKey_ClientAppName, (Object)Cat.getManager().getDomain());
                    headers.put(GRPCServerHelper.MDKey_ChildId, (Object)childId);
                    if (rootMessageId != null) {
                        headers.put(GRPCServerHelper.MDKey_RootMessageId, (Object)rootMessageId);
                    }
                    if (messageId != null) {
                        headers.put(GRPCServerHelper.MDKey_MessageId, (Object)messageId);
                    }
                }
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onHeaders(Metadata headers) {
                        String serviceIP = "";
                        String servicePort = "";
                        if (headers.containsKey(GRPCServerHelper.MDKey_ServiceIPKey)) {
                            serviceIP = (String)headers.get(GRPCServerHelper.MDKey_ServiceIPKey);
                        }
                        if (headers.containsKey(GRPCServerHelper.MDKey_ServicePortKey)) {
                            servicePort = (String)headers.get(GRPCServerHelper.MDKey_ServicePortKey);
                        }
                        Cat.logEvent((String)"PigeonCall.server", (String)serviceIP);
                        Cat.logEvent((String)"PigeonCall.port", (String)servicePort);
                        super.onHeaders(headers);
                    }

                    public void onClose(Status status, Metadata trailers) {
                        if (!isAsyncInterface) {
                            if (status.isOk()) {
                                t.setStatus("0");
                            } else {
                                StatusException se = status.asException(trailers);
                                t.setStatus((Throwable)se);
                                log.error("GRPCServer.CatClientInterceptor.onClose.\u5f02\u5e38:" + GRPCServerHelper.getExceptionStringFromMetadata(trailers), (Throwable)se);
                            }
                            t.complete();
                        }
                        super.onClose(status, trailers);
                    }
                }, headers);
            }

            public void halfClose() {
                super.halfClose();
                if (isAsyncInterface) {
                    t.setStatus("0");
                    t.complete();
                }
            }

            public void cancel(String message, Throwable cause) {
                if (!t.isCompleted()) {
                    t.setStatus(cause);
                    t.complete();
                    log.error("GRPCServer.CatClientInterceptor.cancel.\u5f02\u5e38:" + message, cause);
                }
                super.cancel(message, cause);
            }
        };
    }
}

