/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.grpcserver.client;

import com.xunlei.netty.grpcserver.interceptor.CatClientInterceptor;
import com.xunlei.netty.grpcserver.nameresolver.ConsulNameResolverProvider;
import com.xunlei.netty.soaserver.component.SOAServiceBase;
import com.xunlei.netty.util.GRPCServerHelper;
import com.xunlei.netty.util.Log;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import io.grpc.stub.AbstractStub;
import io.grpc.util.RoundRobinLoadBalancerFactory;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class GRPCClientFactory {
    private static final Logger log = Log.getLogger();
    private SOAServiceBase serviceBase;
    private ManagedChannel grpcChannel;

    public GRPCClientFactory(SOAServiceBase serviceBase) {
        this.serviceBase = serviceBase;
        this.grpcChannel = ManagedChannelBuilder.forTarget((String)("consul://" + this.serviceBase.getAppName())).nameResolverFactory((NameResolver.Factory)new ConsulNameResolverProvider(serviceBase)).usePlaintext(true).loadBalancerFactory((LoadBalancer.Factory)RoundRobinLoadBalancerFactory.getInstance()).build();
    }

    public AbstractStub<?> newBlockingStub(Class grpcServiceInterface) {
        AbstractStub stbu = null;
        if (grpcServiceInterface == null) {
            throw new RuntimeException("grpcServiceInterface\u4e3a\u7a7a");
        }
        try {
            Method method = grpcServiceInterface.getMethod("newBlockingStub", Channel.class);
            if (method != null) {
                stbu = (AbstractStub)method.invoke(null, this.grpcChannel);
                stbu = this.stubWithCommon(stbu).withOption(GRPCServerHelper.COKey_IsAsyncInterface, (Object)false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("GRPC\u5ba2\u6237\u7aef\u5de5\u5382\u7c7b\u5b9e\u4f8bGRPC\u63a5\u53e3[newBlockingStub].\u5f02\u5e38.\u63a5\u53e3\u540d\uff1a" + grpcServiceInterface.getName(), (Throwable)e);
        }
        return stbu;
    }

    public AbstractStub<?> newFutureStub(Class grpcServiceInterface) {
        AbstractStub stbu = null;
        if (grpcServiceInterface == null) {
            throw new RuntimeException("grpcServiceInterface\u4e3a\u7a7a");
        }
        try {
            Method method = grpcServiceInterface.getMethod("newFutureStub", Channel.class);
            if (method != null) {
                stbu = (AbstractStub)method.invoke(null, this.grpcChannel);
                stbu = this.stubWithCommon(stbu).withOption(GRPCServerHelper.COKey_IsAsyncInterface, (Object)true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("GRPC\u5ba2\u6237\u7aef\u5de5\u5382\u7c7b\u5b9e\u4f8bGRPC\u63a5\u53e3[newFutureStub].\u5f02\u5e38.\u63a5\u53e3\u540d\uff1a" + grpcServiceInterface.getName(), (Throwable)e);
        }
        return stbu;
    }

    private AbstractStub<?> stubWithCommon(AbstractStub<?> stub) {
        stub = stub.withInterceptors(new ClientInterceptor[]{new CatClientInterceptor()});
        long connectionTimeout = this.serviceBase.getConnectionTimeout();
        if (connectionTimeout > 0L) {
            stub = stub.withOption(GRPCServerHelper.COKey_ConnectionTimeout, (Object)connectionTimeout);
        }
        return stub;
    }

    public void shutdowm() throws InterruptedException {
        if (this.grpcChannel != null) {
            this.grpcChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
    }
}

